/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import java.util.List;
import org.apache.spark.network.protocol.AbstractResponseMessage;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.MessageWithHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.io.netty.buffer.ByteBuf;
import org.spark_project.io.netty.channel.ChannelHandler;
import org.spark_project.io.netty.channel.ChannelHandlerContext;
import org.spark_project.io.netty.handler.codec.MessageToMessageEncoder;

@ChannelHandler.Sharable
public final class MessageEncoder
extends MessageToMessageEncoder<Message> {
    private static final Logger logger = LoggerFactory.getLogger(MessageEncoder.class);
    public static final MessageEncoder INSTANCE = new MessageEncoder();

    private MessageEncoder() {
    }

    @Override
    public void encode(ChannelHandlerContext ctx, Message in, List<Object> out) throws Exception {
        Object body2 = null;
        long bodyLength = 0L;
        boolean isBodyInFrame = false;
        if (in.body() != null) {
            try {
                bodyLength = in.body().size();
                body2 = in.body().convertToNetty();
                isBodyInFrame = in.isBodyInFrame();
            }
            catch (Exception e) {
                in.body().release();
                if (!(in instanceof AbstractResponseMessage)) {
                    throw e;
                }
                AbstractResponseMessage resp = (AbstractResponseMessage)in;
                String error2 = e.getMessage() != null ? e.getMessage() : "null";
                logger.error(String.format("Error processing %s for client %s", in, ctx.channel().remoteAddress()), (Throwable)e);
                this.encode(ctx, resp.createFailureResponse(error2), out);
                return;
            }
        }
        Message.Type msgType = in.type();
        int headerLength2 = 8 + msgType.encodedLength() + in.encodedLength();
        long frameLength = (long)headerLength2 + (isBodyInFrame ? bodyLength : 0L);
        ByteBuf header = ctx.alloc().heapBuffer(headerLength2);
        header.writeLong(frameLength);
        msgType.encode(header);
        in.encode(header);
        assert (header.writableBytes() == 0);
        if (body2 != null) {
            out.add(new MessageWithHeader(in.body(), header, body2, bodyLength));
        } else {
            out.add(header);
        }
    }
}

