/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import java.nio.charset.StandardCharsets;
import org.spark_project.io.netty.buffer.ByteBuf;

public class Encoders {

    public static class StringArrays {
        public static int encodedLength(String[] strings) {
            int totalLength = 4;
            for (String s : strings) {
                totalLength += Strings.encodedLength(s);
            }
            return totalLength;
        }

        public static void encode(ByteBuf buf, String[] strings) {
            buf.writeInt(strings.length);
            for (String s : strings) {
                Strings.encode(buf, s);
            }
        }

        public static String[] decode(ByteBuf buf) {
            int numStrings = buf.readInt();
            String[] strings = new String[numStrings];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = Strings.decode(buf);
            }
            return strings;
        }
    }

    public static class ByteArrays {
        public static int encodedLength(byte[] arr) {
            return 4 + arr.length;
        }

        public static void encode(ByteBuf buf, byte[] arr) {
            buf.writeInt(arr.length);
            buf.writeBytes(arr);
        }

        public static byte[] decode(ByteBuf buf) {
            int length = buf.readInt();
            byte[] bytes2 = new byte[length];
            buf.readBytes(bytes2);
            return bytes2;
        }
    }

    public static class Strings {
        public static int encodedLength(String s) {
            return 4 + s.getBytes(StandardCharsets.UTF_8).length;
        }

        public static void encode(ByteBuf buf, String s) {
            byte[] bytes2 = s.getBytes(StandardCharsets.UTF_8);
            buf.writeInt(bytes2.length);
            buf.writeBytes(bytes2);
        }

        public static String decode(ByteBuf buf) {
            int length = buf.readInt();
            byte[] bytes2 = new byte[length];
            buf.readBytes(bytes2);
            return new String(bytes2, StandardCharsets.UTF_8);
        }
    }
}

