/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.crypto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.commons.crypto.stream.CryptoOutputStream;
import org.apache.spark.network.util.AbstractFileRegion;
import org.apache.spark.network.util.ByteArrayReadableChannel;
import org.apache.spark.network.util.ByteArrayWritableChannel;
import org.spark_project.guava.annotations.VisibleForTesting;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.io.netty.buffer.ByteBuf;
import org.spark_project.io.netty.buffer.Unpooled;
import org.spark_project.io.netty.channel.Channel;
import org.spark_project.io.netty.channel.ChannelHandler;
import org.spark_project.io.netty.channel.ChannelHandlerContext;
import org.spark_project.io.netty.channel.ChannelInboundHandlerAdapter;
import org.spark_project.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.spark_project.io.netty.channel.ChannelPromise;
import org.spark_project.io.netty.channel.FileRegion;

public class TransportCipher {
    @VisibleForTesting
    static final String ENCRYPTION_HANDLER_NAME = "TransportEncryption";
    private static final String DECRYPTION_HANDLER_NAME = "TransportDecryption";
    private static final int STREAM_BUFFER_SIZE = 32768;
    private final Properties conf;
    private final String cipher;
    private final SecretKeySpec key;
    private final byte[] inIv;
    private final byte[] outIv;

    public TransportCipher(Properties conf, String cipher, SecretKeySpec key, byte[] inIv, byte[] outIv) {
        this.conf = conf;
        this.cipher = cipher;
        this.key = key;
        this.inIv = inIv;
        this.outIv = outIv;
    }

    public String getCipherTransformation() {
        return this.cipher;
    }

    @VisibleForTesting
    SecretKeySpec getKey() {
        return this.key;
    }

    public byte[] getInputIv() {
        return this.inIv;
    }

    public byte[] getOutputIv() {
        return this.outIv;
    }

    private CryptoOutputStream createOutputStream(WritableByteChannel ch) throws IOException {
        return new CryptoOutputStream(this.cipher, this.conf, ch, (Key)this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.outIv));
    }

    private CryptoInputStream createInputStream(ReadableByteChannel ch) throws IOException {
        return new CryptoInputStream(this.cipher, this.conf, ch, (Key)this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.inIv));
    }

    public void addToChannel(Channel ch) throws IOException {
        ch.pipeline().addFirst(ENCRYPTION_HANDLER_NAME, (ChannelHandler)new EncryptionHandler(this)).addFirst(DECRYPTION_HANDLER_NAME, (ChannelHandler)new DecryptionHandler(this));
    }

    private static class EncryptedMessage
    extends AbstractFileRegion {
        private final boolean isByteBuf;
        private final ByteBuf buf;
        private final FileRegion region;
        private final CryptoOutputStream cos;
        private final EncryptionHandler handler;
        private long transferred;
        private ByteArrayWritableChannel byteEncChannel;
        private ByteArrayWritableChannel byteRawChannel;
        private ByteBuffer currentEncrypted;

        EncryptedMessage(EncryptionHandler handler, CryptoOutputStream cos, Object msg, ByteArrayWritableChannel ch) {
            Preconditions.checkArgument(msg instanceof ByteBuf || msg instanceof FileRegion, "Unrecognized message type: %s", msg.getClass().getName());
            this.handler = handler;
            this.isByteBuf = msg instanceof ByteBuf;
            this.buf = this.isByteBuf ? (ByteBuf)msg : null;
            this.region = this.isByteBuf ? null : (FileRegion)msg;
            this.transferred = 0L;
            this.byteRawChannel = new ByteArrayWritableChannel(32768);
            this.cos = cos;
            this.byteEncChannel = ch;
        }

        @Override
        public long count() {
            return this.isByteBuf ? (long)this.buf.readableBytes() : this.region.count();
        }

        @Override
        public long position() {
            return 0L;
        }

        @Override
        public long transferred() {
            return this.transferred;
        }

        @Override
        public EncryptedMessage touch(Object o) {
            super.touch(o);
            if (this.region != null) {
                this.region.touch(o);
            }
            if (this.buf != null) {
                this.buf.touch(o);
            }
            return this;
        }

        @Override
        public EncryptedMessage retain(int increment) {
            super.retain(increment);
            if (this.region != null) {
                this.region.retain(increment);
            }
            if (this.buf != null) {
                this.buf.retain(increment);
            }
            return this;
        }

        @Override
        public boolean release(int decrement) {
            if (this.region != null) {
                this.region.release(decrement);
            }
            if (this.buf != null) {
                this.buf.release(decrement);
            }
            return super.release(decrement);
        }

        @Override
        public long transferTo(WritableByteChannel target, long position2) throws IOException {
            Preconditions.checkArgument(position2 == this.transferred(), "Invalid position.");
            do {
                if (this.currentEncrypted == null) {
                    this.encryptMore();
                }
                int bytesWritten = this.currentEncrypted.remaining();
                target.write(this.currentEncrypted);
                this.transferred += (long)(bytesWritten -= this.currentEncrypted.remaining());
                if (this.currentEncrypted.hasRemaining()) continue;
                this.currentEncrypted = null;
                this.byteEncChannel.reset();
            } while (this.transferred < this.count());
            return this.transferred;
        }

        private void encryptMore() throws IOException {
            if (!this.handler.isCipherValid()) {
                throw new IOException("Cipher is in invalid state.");
            }
            this.byteRawChannel.reset();
            if (this.isByteBuf) {
                int copied = this.byteRawChannel.write(this.buf.nioBuffer());
                this.buf.skipBytes(copied);
            } else {
                this.region.transferTo(this.byteRawChannel, this.region.transferred());
            }
            try {
                this.cos.write(this.byteRawChannel.getData(), 0, this.byteRawChannel.length());
                this.cos.flush();
            }
            catch (InternalError ie) {
                this.handler.reportError();
                throw ie;
            }
            this.currentEncrypted = ByteBuffer.wrap(this.byteEncChannel.getData(), 0, this.byteEncChannel.length());
        }

        @Override
        protected void deallocate() {
            this.byteRawChannel.reset();
            this.byteEncChannel.reset();
            if (this.region != null) {
                this.region.release();
            }
            if (this.buf != null) {
                this.buf.release();
            }
        }
    }

    private static class DecryptionHandler
    extends ChannelInboundHandlerAdapter {
        private final CryptoInputStream cis;
        private final ByteArrayReadableChannel byteChannel = new ByteArrayReadableChannel();
        private boolean isCipherValid;

        DecryptionHandler(TransportCipher cipher) throws IOException {
            this.cis = cipher.createInputStream(this.byteChannel);
            this.isCipherValid = true;
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object data) throws Exception {
            if (!this.isCipherValid) {
                throw new IOException("Cipher is in invalid state.");
            }
            this.byteChannel.feedData((ByteBuf)data);
            byte[] decryptedData = new byte[this.byteChannel.readableBytes()];
            for (int offset = 0; offset < decryptedData.length; offset += this.cis.read(decryptedData, offset, decryptedData.length - offset)) {
                try {
                    continue;
                }
                catch (InternalError ie) {
                    this.isCipherValid = false;
                    throw ie;
                }
            }
            ctx.fireChannelRead(Unpooled.wrappedBuffer(decryptedData, 0, decryptedData.length));
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            try {
                if (this.isCipherValid) {
                    this.cis.close();
                }
            }
            finally {
                super.channelInactive(ctx);
            }
        }
    }

    private static class EncryptionHandler
    extends ChannelOutboundHandlerAdapter {
        private final ByteArrayWritableChannel byteChannel = new ByteArrayWritableChannel(32768);
        private final CryptoOutputStream cos;
        private boolean isCipherValid;

        EncryptionHandler(TransportCipher cipher) throws IOException {
            this.cos = cipher.createOutputStream(this.byteChannel);
            this.isCipherValid = true;
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            ctx.write(new EncryptedMessage(this, this.cos, msg, this.byteChannel), promise);
        }

        @Override
        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            try {
                if (this.isCipherValid) {
                    this.cos.close();
                }
            }
            finally {
                super.close(ctx, promise);
            }
        }

        void reportError() {
            this.isCipherValid = false;
        }

        boolean isCipherValid() {
            return this.isCipherValid;
        }
    }
}

