/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.crypto;

import java.nio.ByteBuffer;
import org.apache.spark.network.protocol.Encodable;
import org.apache.spark.network.protocol.Encoders;
import org.spark_project.io.netty.buffer.ByteBuf;
import org.spark_project.io.netty.buffer.Unpooled;

public class ServerResponse
implements Encodable {
    private static final byte TAG_BYTE = -5;
    public final byte[] response;
    public final byte[] nonce;
    public final byte[] inputIv;
    public final byte[] outputIv;

    public ServerResponse(byte[] response, byte[] nonce, byte[] inputIv, byte[] outputIv) {
        this.response = response;
        this.nonce = nonce;
        this.inputIv = inputIv;
        this.outputIv = outputIv;
    }

    @Override
    public int encodedLength() {
        return 1 + Encoders.ByteArrays.encodedLength(this.response) + Encoders.ByteArrays.encodedLength(this.nonce) + Encoders.ByteArrays.encodedLength(this.inputIv) + Encoders.ByteArrays.encodedLength(this.outputIv);
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeByte(-5);
        Encoders.ByteArrays.encode(buf, this.response);
        Encoders.ByteArrays.encode(buf, this.nonce);
        Encoders.ByteArrays.encode(buf, this.inputIv);
        Encoders.ByteArrays.encode(buf, this.outputIv);
    }

    public static ServerResponse decodeMessage(ByteBuffer buffer) {
        ByteBuf buf = Unpooled.wrappedBuffer(buffer);
        if (buf.readByte() != -5) {
            throw new IllegalArgumentException("Expected ServerResponse, received something else.");
        }
        return new ServerResponse(Encoders.ByteArrays.decode(buf), Encoders.ByteArrays.decode(buf), Encoders.ByteArrays.decode(buf), Encoders.ByteArrays.decode(buf));
    }
}

