/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.crypto;

import java.nio.ByteBuffer;
import org.apache.spark.network.protocol.Encodable;
import org.apache.spark.network.protocol.Encoders;
import org.spark_project.io.netty.buffer.ByteBuf;
import org.spark_project.io.netty.buffer.Unpooled;

public class ClientChallenge
implements Encodable {
    private static final byte TAG_BYTE = -6;
    public final String appId;
    public final String kdf;
    public final int iterations;
    public final String cipher;
    public final int keyLength;
    public final byte[] nonce;
    public final byte[] challenge;

    public ClientChallenge(String appId, String kdf, int iterations, String cipher, int keyLength, byte[] nonce, byte[] challenge) {
        this.appId = appId;
        this.kdf = kdf;
        this.iterations = iterations;
        this.cipher = cipher;
        this.keyLength = keyLength;
        this.nonce = nonce;
        this.challenge = challenge;
    }

    @Override
    public int encodedLength() {
        return 9 + Encoders.Strings.encodedLength(this.appId) + Encoders.Strings.encodedLength(this.kdf) + Encoders.Strings.encodedLength(this.cipher) + Encoders.ByteArrays.encodedLength(this.nonce) + Encoders.ByteArrays.encodedLength(this.challenge);
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeByte(-6);
        Encoders.Strings.encode(buf, this.appId);
        Encoders.Strings.encode(buf, this.kdf);
        buf.writeInt(this.iterations);
        Encoders.Strings.encode(buf, this.cipher);
        buf.writeInt(this.keyLength);
        Encoders.ByteArrays.encode(buf, this.nonce);
        Encoders.ByteArrays.encode(buf, this.challenge);
    }

    public static ClientChallenge decodeMessage(ByteBuffer buffer) {
        ByteBuf buf = Unpooled.wrappedBuffer(buffer);
        if (buf.readByte() != -6) {
            throw new IllegalArgumentException("Expected ClientChallenge, received something else.");
        }
        return new ClientChallenge(Encoders.Strings.decode(buf), Encoders.Strings.decode(buf), buf.readInt(), Encoders.Strings.decode(buf), buf.readInt(), Encoders.ByteArrays.decode(buf), Encoders.ByteArrays.decode(buf));
    }
}

