/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.crypto;

import org.apache.spark.network.crypto.AuthRpcHandler;
import org.apache.spark.network.sasl.SaslServerBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.util.TransportConf;
import org.spark_project.io.netty.channel.Channel;

public class AuthServerBootstrap
implements TransportServerBootstrap {
    private final TransportConf conf;
    private final SecretKeyHolder secretKeyHolder;

    public AuthServerBootstrap(TransportConf conf, SecretKeyHolder secretKeyHolder) {
        this.conf = conf;
        this.secretKeyHolder = secretKeyHolder;
    }

    @Override
    public RpcHandler doBootstrap(Channel channel, RpcHandler rpcHandler) {
        if (!this.conf.encryptionEnabled()) {
            SaslServerBootstrap sasl = new SaslServerBootstrap(this.conf, this.secretKeyHolder);
            return sasl.doBootstrap(channel, rpcHandler);
        }
        return new AuthRpcHandler(this.conf, channel, rpcHandler, this.secretKeyHolder);
    }
}

