/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.crypto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.crypto.AuthEngine;
import org.apache.spark.network.crypto.ClientChallenge;
import org.apache.spark.network.crypto.ServerResponse;
import org.apache.spark.network.sasl.SaslClientBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.base.Throwables;
import org.spark_project.io.netty.buffer.ByteBuf;
import org.spark_project.io.netty.buffer.Unpooled;
import org.spark_project.io.netty.channel.Channel;

public class AuthClientBootstrap
implements TransportClientBootstrap {
    private static final Logger LOG = LoggerFactory.getLogger(AuthClientBootstrap.class);
    private final TransportConf conf;
    private final String appId;
    private final SecretKeyHolder secretKeyHolder;

    public AuthClientBootstrap(TransportConf conf, String appId, SecretKeyHolder secretKeyHolder) {
        this.conf = conf;
        this.appId = appId;
        this.secretKeyHolder = secretKeyHolder;
    }

    @Override
    public void doBootstrap(TransportClient client, Channel channel) {
        if (!this.conf.encryptionEnabled()) {
            LOG.debug("AES encryption disabled, using old auth protocol.");
            this.doSaslAuth(client, channel);
            return;
        }
        try {
            this.doSparkAuth(client, channel);
        }
        catch (IOException | GeneralSecurityException e) {
            throw Throwables.propagate(e);
        }
        catch (RuntimeException e) {
            if (this.conf.saslFallback()) {
                LOG.warn("New auth protocol failed, trying SASL.", (Throwable)e);
                this.doSaslAuth(client, channel);
            }
            throw e;
        }
    }

    private void doSparkAuth(TransportClient client, Channel channel) throws GeneralSecurityException, IOException {
        String secretKey = this.secretKeyHolder.getSecretKey(this.appId);
        try (AuthEngine engine = new AuthEngine(this.appId, secretKey, this.conf);){
            ClientChallenge challenge = engine.challenge();
            ByteBuf challengeData = Unpooled.buffer(challenge.encodedLength());
            challenge.encode(challengeData);
            ByteBuffer responseData = client.sendRpcSync(challengeData.nioBuffer(), this.conf.authRTTimeoutMs());
            ServerResponse response = ServerResponse.decodeMessage(responseData);
            engine.validate(response);
            engine.sessionCipher().addToChannel(channel);
        }
    }

    private void doSaslAuth(TransportClient client, Channel channel) {
        SaslClientBootstrap sasl = new SaslClientBootstrap(this.conf, this.appId, this.secretKeyHolder);
        sasl.doBootstrap(client, channel);
    }
}

