/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.spark_project.guava.base.Objects;
import org.spark_project.io.netty.buffer.ByteBuf;
import org.spark_project.io.netty.buffer.ByteBufInputStream;

public class NettyManagedBuffer
extends ManagedBuffer {
    private final ByteBuf buf;

    public NettyManagedBuffer(ByteBuf buf) {
        this.buf = buf;
    }

    @Override
    public long size() {
        return this.buf.readableBytes();
    }

    @Override
    public ByteBuffer nioByteBuffer() throws IOException {
        return this.buf.nioBuffer();
    }

    @Override
    public InputStream createInputStream() throws IOException {
        return new ByteBufInputStream(this.buf);
    }

    @Override
    public ManagedBuffer retain() {
        this.buf.retain();
        return this;
    }

    @Override
    public ManagedBuffer release() {
        this.buf.release();
        return this;
    }

    @Override
    public Object convertToNetty() throws IOException {
        return this.buf.duplicate().retain();
    }

    public String toString() {
        return Objects.toStringHelper(this).add("buf", this.buf).toString();
    }
}

