/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.util.StringTokenizer;

public final class PathUtils {
    private PathUtils() {
    }

    public static String dirname(String path2) {
        int i = path2.lastIndexOf("/");
        return i >= 0 ? path2.substring(0, i) : "";
    }

    public static String filename(String path2) {
        int i = path2.lastIndexOf("/");
        return i >= 0 ? path2.substring(i + 1) : path2;
    }

    public static String[] dirnames(String path2) {
        String dirname = PathUtils.dirname(path2);
        return PathUtils.split(dirname, "/", -1);
    }

    private static String[] split(String str, String separator, int max2) {
        StringTokenizer tok = separator == null ? new StringTokenizer(str) : new StringTokenizer(str, separator);
        int listSize = tok.countTokens();
        if (max2 > 0 && listSize > max2) {
            listSize = max2;
        }
        String[] list2 = new String[listSize];
        int i = 0;
        int lastTokenEnd = 0;
        while (tok.hasMoreTokens()) {
            int lastTokenBegin;
            if (max2 > 0 && i == listSize - 1) {
                String endToken = tok.nextToken();
                lastTokenBegin = str.indexOf(endToken, lastTokenEnd);
                list2[i] = str.substring(lastTokenBegin);
                break;
            }
            list2[i] = tok.nextToken();
            lastTokenBegin = str.indexOf(list2[i], lastTokenEnd);
            lastTokenEnd = lastTokenBegin + list2[i].length();
            ++i;
        }
        return list2;
    }

    public static String host(String url) {
        if (url == null || url.length() == 0) {
            return "localhost";
        }
        String authorization = PathUtils.authorization(url);
        int index = authorization.indexOf(64);
        String host = index >= 0 ? authorization.substring(index + 1) : authorization;
        return host.charAt(0) == '[' && host.charAt(host.length() - 1) == ']' ? host.substring(1, host.length() - 1) : host;
    }

    static String authorization(String url) {
        int pos2;
        if (url == null) {
            return "localhost";
        }
        String protocol = PathUtils.protocol(url);
        if (protocol == null || protocol.equalsIgnoreCase("file")) {
            return "localhost";
        }
        String host = url;
        if (protocol.equalsIgnoreCase("scm")) {
            host = host.substring(host.indexOf(":", 4) + 1).trim();
        }
        if ((host = host.substring(host.indexOf(":") + 1).trim()).startsWith("//")) {
            host = host.substring(2);
        }
        if ((pos2 = host.indexOf("/")) > 0) {
            host = host.substring(0, pos2);
        }
        int n = pos2 = (pos2 = host.indexOf(64)) > 0 ? PathUtils.endOfHostPosition(host, pos2) : PathUtils.endOfHostPosition(host, 0);
        if (pos2 > 0) {
            host = host.substring(0, pos2);
        }
        return host;
    }

    private static int endOfHostPosition(String host, int pos2) {
        int endOfIPv6Pos = host.indexOf(93, pos2);
        return endOfIPv6Pos > 0 ? endOfIPv6Pos + 1 : host.indexOf(":", pos2);
    }

    public static String protocol(String url) {
        int pos2 = url.indexOf(":");
        if (pos2 == -1) {
            return "";
        }
        return url.substring(0, pos2).trim();
    }

    public static int port(String url) {
        String protocol = PathUtils.protocol(url);
        if (protocol == null || protocol.equalsIgnoreCase("file")) {
            return -1;
        }
        String authorization = PathUtils.authorization(url);
        if (authorization == null) {
            return -1;
        }
        if (protocol.equalsIgnoreCase("scm")) {
            url = url.substring(url.indexOf(":", 4) + 1).trim();
        }
        if (url.regionMatches(true, 0, "file:", 0, 5) || url.regionMatches(true, 0, "local:", 0, 6)) {
            return -1;
        }
        if ((url = url.substring(url.indexOf(":") + 1).trim()).startsWith("//")) {
            url = url.substring(2);
        }
        int start2 = authorization.length();
        if (url.length() > start2 && url.charAt(start2) == ':') {
            int end = url.indexOf(47, start2);
            if (end == start2 + 1) {
                return -1;
            }
            if (end == -1) {
                end = url.length();
            }
            return Integer.parseInt(url.substring(start2 + 1, end));
        }
        return -1;
    }

    public static String basedir(String url) {
        String protocol = PathUtils.protocol(url);
        String retValue = null;
        if (protocol.equalsIgnoreCase("scm") && url.regionMatches(true, 0, "scm:svn:", 0, 8)) {
            url = url.substring(url.indexOf(":", 4) + 1);
            protocol = PathUtils.protocol(url);
        }
        if (protocol.equalsIgnoreCase("file")) {
            retValue = url.substring(protocol.length() + 1);
            if ((retValue = PathUtils.decode(retValue)).startsWith("//")) {
                if ((retValue = retValue.substring(2)).length() >= 2 && (retValue.charAt(1) == '|' || retValue.charAt(1) == ':')) {
                    retValue = retValue.charAt(0) + ":" + retValue.substring(2);
                } else {
                    int index = retValue.indexOf("/");
                    if (index >= 0) {
                        retValue = retValue.substring(index + 1);
                    }
                    if (retValue.length() >= 2 && (retValue.charAt(1) == '|' || retValue.charAt(1) == ':')) {
                        retValue = retValue.charAt(0) + ":" + retValue.substring(2);
                    } else if (index >= 0) {
                        retValue = "/" + retValue;
                    }
                }
            }
            if (retValue.length() >= 2 && retValue.charAt(1) == '|') {
                retValue = retValue.charAt(0) + ":" + retValue.substring(2);
            }
        } else {
            String authorization = PathUtils.authorization(url);
            int port = PathUtils.port(url);
            int pos2 = 0;
            if (protocol.equalsIgnoreCase("scm")) {
                pos2 = url.indexOf(":", 4) + 1;
                pos2 = url.indexOf(":", pos2) + 1;
            } else {
                int index = url.indexOf("://");
                if (index != -1) {
                    pos2 = index + 3;
                }
            }
            pos2 += authorization.length();
            if (port != -1) {
                pos2 = pos2 + Integer.toString(port).length() + 1;
            }
            if (url.length() > pos2) {
                retValue = url.substring(pos2);
                if (retValue.startsWith(":")) {
                    retValue = retValue.substring(1);
                }
                retValue = retValue.replace(':', '/');
            }
        }
        if (retValue == null) {
            retValue = "/";
        }
        return retValue.trim();
    }

    private static String decode(String url) {
        String decoded = url;
        if (url != null) {
            int pos2 = -1;
            while ((pos2 = decoded.indexOf(37, pos2 + 1)) >= 0) {
                if (pos2 + 2 >= decoded.length()) continue;
                String hexStr = decoded.substring(pos2 + 1, pos2 + 3);
                char ch = (char)Integer.parseInt(hexStr, 16);
                decoded = decoded.substring(0, pos2) + ch + decoded.substring(pos2 + 3);
            }
        }
        return decoded;
    }

    public static String user(String url) {
        String host = PathUtils.authorization(url);
        int index = host.indexOf(64);
        if (index > 0) {
            String userInfo = host.substring(0, index);
            if ((index = userInfo.indexOf(58)) > 0) {
                return userInfo.substring(0, index);
            }
            if (index < 0) {
                return userInfo;
            }
        }
        return null;
    }

    public static String password(String url) {
        String userInfo;
        String host = PathUtils.authorization(url);
        int index = host.indexOf(64);
        if (index > 0 && (index = (userInfo = host.substring(0, index)).indexOf(58)) >= 0) {
            return userInfo.substring(index + 1);
        }
        return null;
    }

    public static String toRelative(File basedir, String absolutePath) {
        String relative;
        String basedirPath;
        if ((absolutePath = absolutePath.replace('\\', '/')).startsWith(basedirPath = basedir.getAbsolutePath().replace('\\', '/'))) {
            relative = absolutePath.substring(basedirPath.length());
            if (relative.startsWith("/")) {
                relative = relative.substring(1);
            }
            if (relative.length() <= 0) {
                relative = ".";
            }
        } else {
            relative = absolutePath;
        }
        return relative;
    }
}

