/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.Validate;
import org.apache.maven.toolchain.io.ToolchainsParseException;
import org.apache.maven.toolchain.io.ToolchainsReader;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.io.xpp3.MavenToolchainsXpp3Reader;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named
@Singleton
public class DefaultToolchainsReader
implements ToolchainsReader {
    @Override
    public PersistedToolchains read(File input2, Map<String, ?> options2) throws IOException {
        Validate.notNull(input2, "input cannot be null", new Object[0]);
        return this.read(ReaderFactory.newXmlReader(input2), options2);
    }

    @Override
    public PersistedToolchains read(Reader input2, Map<String, ?> options2) throws IOException {
        Validate.notNull(input2, "input cannot be null", new Object[0]);
        try {
            MavenToolchainsXpp3Reader r = new MavenToolchainsXpp3Reader();
            PersistedToolchains persistedToolchains = r.read(input2, this.isStrict(options2));
            return persistedToolchains;
        }
        catch (XmlPullParserException e) {
            throw new ToolchainsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close(input2);
        }
    }

    @Override
    public PersistedToolchains read(InputStream input2, Map<String, ?> options2) throws IOException {
        Validate.notNull(input2, "input cannot be null", new Object[0]);
        try {
            MavenToolchainsXpp3Reader r = new MavenToolchainsXpp3Reader();
            PersistedToolchains persistedToolchains = r.read(input2, this.isStrict(options2));
            return persistedToolchains;
        }
        catch (XmlPullParserException e) {
            throw new ToolchainsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close(input2);
        }
    }

    private boolean isStrict(Map<String, ?> options2) {
        Object value2 = options2 != null ? (Object)options2.get("org.apache.maven.toolchains.io.isStrict") : null;
        return value2 == null || Boolean.parseBoolean(value2.toString());
    }
}

