/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.logging;

import org.apache.maven.shared.utils.logging.AnsiMessageBuilder;
import org.apache.maven.shared.utils.logging.LoggerLevelRenderer;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.PlainMessageBuilder;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class MessageUtils {
    private static final boolean JANSI;

    public static void systemInstall() {
        if (JANSI) {
            AnsiConsole.systemInstall();
        }
    }

    public static void systemUninstall() {
        if (JANSI) {
            AnsiConsole.systemUninstall();
        }
    }

    public static void setColorEnabled(boolean flag) {
        if (JANSI) {
            Ansi.setEnabled(flag);
        }
    }

    public static boolean isColorEnabled() {
        return JANSI ? Ansi.isEnabled() : false;
    }

    public static MessageBuilder buffer() {
        return (MessageBuilder)((Object)(JANSI ? new AnsiMessageBuilder() : new PlainMessageBuilder()));
    }

    public static MessageBuilder buffer(StringBuilder builder) {
        return (MessageBuilder)((Object)(JANSI ? new AnsiMessageBuilder(builder) : new PlainMessageBuilder(builder)));
    }

    public static MessageBuilder buffer(int size2) {
        return (MessageBuilder)((Object)(JANSI ? new AnsiMessageBuilder(size2) : new PlainMessageBuilder(size2)));
    }

    public static LoggerLevelRenderer level() {
        return JANSI ? new AnsiMessageBuilder(20) : new PlainMessageBuilder(7);
    }

    public static String stripAnsiCodes(String msg) {
        return msg.replaceAll("\u001b\\[[;\\d]*[ -/]*[@-~]", "");
    }

    static {
        boolean jansi = true;
        try {
            Class.forName("org.fusesource.jansi.Ansi");
        }
        catch (ClassNotFoundException cnfe) {
            jansi = false;
        }
        JANSI = jansi;
    }
}

