/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.introspection;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.introspection.ClassMap;
import org.apache.maven.shared.utils.introspection.IntrospectionException;
import org.apache.maven.shared.utils.introspection.MethodMap;

public class ReflectionValueExtractor {
    private static final Class<?>[] CLASS_ARGS = new Class[0];
    private static final Object[] OBJECT_ARGS = new Object[0];
    private static final Map<Class<?>, ClassMap> CLASS_MAPS = new WeakHashMap();
    static final int EOF = -1;
    static final char PROPERTY_START = '.';
    static final char INDEXED_START = '[';
    static final char INDEXED_END = ']';
    static final char MAPPED_START = '(';
    static final char MAPPED_END = ')';

    private ReflectionValueExtractor() {
    }

    public static Object evaluate(@Nonnull String expression, @Nullable Object root2) throws IntrospectionException {
        return ReflectionValueExtractor.evaluate(expression, root2, true);
    }

    public static Object evaluate(@Nonnull String expression, @Nullable Object root2, boolean trimRootToken) throws IntrospectionException {
        Tokenizer tokenizer;
        boolean hasDots;
        Object value2 = root2;
        if (StringUtils.isEmpty(expression) || !Character.isJavaIdentifierStart(expression.charAt(0))) {
            return null;
        }
        boolean bl = hasDots = expression.indexOf(46) >= 0;
        if (trimRootToken && hasDots) {
            tokenizer = new Tokenizer(expression);
            tokenizer.nextPropertyName();
            if (tokenizer.getPosition() == -1) {
                return null;
            }
        } else {
            tokenizer = new Tokenizer("." + expression);
        }
        int propertyPosition = tokenizer.getPosition();
        block5: while (value2 != null && tokenizer.peekChar() != -1) {
            switch (tokenizer.skipChar()) {
                case 91: {
                    value2 = ReflectionValueExtractor.getIndexedValue(expression, propertyPosition, tokenizer.getPosition(), value2, tokenizer.nextToken(']'));
                    continue block5;
                }
                case 40: {
                    value2 = ReflectionValueExtractor.getMappedValue(expression, propertyPosition, tokenizer.getPosition(), value2, tokenizer.nextToken(')'));
                    continue block5;
                }
                case 46: {
                    propertyPosition = tokenizer.getPosition();
                    value2 = ReflectionValueExtractor.getPropertyValue(value2, tokenizer.nextPropertyName());
                    continue block5;
                }
            }
            return null;
        }
        return value2;
    }

    private static Object getMappedValue(String expression, int from, int to, Object value2, String key) throws IntrospectionException {
        if (value2 == null || key == null) {
            return null;
        }
        if (value2 instanceof Map) {
            Object[] localParams = new Object[]{key};
            ClassMap classMap = ReflectionValueExtractor.getClassMap(value2.getClass());
            try {
                Method method = classMap.findMethod("get", localParams);
                return method.invoke(value2, localParams);
            }
            catch (MethodMap.AmbiguousException e) {
                throw new IntrospectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new IntrospectionException(e);
            }
            catch (InvocationTargetException e) {
                throw new IntrospectionException(e.getTargetException());
            }
        }
        String message = String.format("The token '%s' at position '%d' refers to a java.util.Map, but the value seems is an instance of '%s'", expression.subSequence(from, to), from, value2.getClass());
        throw new IntrospectionException(message);
    }

    private static Object getIndexedValue(String expression, int from, int to, Object value2, String indexStr) throws IntrospectionException {
        try {
            int index = Integer.parseInt(indexStr);
            if (value2.getClass().isArray()) {
                return Array.get(value2, index);
            }
            if (value2 instanceof List) {
                ClassMap classMap = ReflectionValueExtractor.getClassMap(value2.getClass());
                Object[] localParams = new Object[]{index};
                Method method = null;
                try {
                    method = classMap.findMethod("get", localParams);
                    return method.invoke(value2, localParams);
                }
                catch (MethodMap.AmbiguousException e) {
                    throw new IntrospectionException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IntrospectionException(e);
                }
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IndexOutOfBoundsException) {
                return null;
            }
            throw new IntrospectionException(e.getTargetException());
        }
        String message = String.format("The token '%s' at position '%d' refers to a java.util.List or an array, but the value seems is an instance of '%s'", expression.subSequence(from, to), from, value2.getClass());
        throw new IntrospectionException(message);
    }

    private static Object getPropertyValue(Object value2, String property) throws IntrospectionException {
        if (value2 == null || property == null) {
            return null;
        }
        ClassMap classMap = ReflectionValueExtractor.getClassMap(value2.getClass());
        String methodBase = StringUtils.capitalizeFirstLetter(property);
        String methodName = "get" + methodBase;
        try {
            Method method = classMap.findMethod(methodName, CLASS_ARGS);
            if (method == null) {
                methodName = "is" + methodBase;
                method = classMap.findMethod(methodName, CLASS_ARGS);
            }
            if (method == null) {
                return null;
            }
            return method.invoke(value2, OBJECT_ARGS);
        }
        catch (InvocationTargetException e) {
            throw new IntrospectionException(e.getTargetException());
        }
        catch (MethodMap.AmbiguousException e) {
            throw new IntrospectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new IntrospectionException(e);
        }
    }

    private static ClassMap getClassMap(Class<?> clazz2) {
        ClassMap classMap = CLASS_MAPS.get(clazz2);
        if (classMap == null) {
            classMap = new ClassMap(clazz2);
            CLASS_MAPS.put(clazz2, classMap);
        }
        return classMap;
    }

    static class Tokenizer {
        final String expression;
        int idx;

        public Tokenizer(String expression) {
            this.expression = expression;
        }

        public int peekChar() {
            return this.idx < this.expression.length() ? (int)this.expression.charAt(this.idx) : -1;
        }

        public int skipChar() {
            return this.idx < this.expression.length() ? (int)this.expression.charAt(this.idx++) : -1;
        }

        public String nextToken(char delimiter) {
            int start2 = this.idx;
            while (this.idx < this.expression.length() && delimiter != this.expression.charAt(this.idx)) {
                ++this.idx;
            }
            if (this.idx <= start2 || this.idx >= this.expression.length()) {
                return null;
            }
            return this.expression.substring(start2, this.idx++);
        }

        public String nextPropertyName() {
            int start2 = this.idx;
            while (this.idx < this.expression.length() && Character.isJavaIdentifierPart(this.expression.charAt(this.idx))) {
                ++this.idx;
            }
            if (this.idx <= start2 || this.idx > this.expression.length()) {
                return null;
            }
            return this.expression.substring(start2, this.idx);
        }

        public int getPosition() {
            return this.idx < this.expression.length() ? this.idx : -1;
        }

        public String toString() {
            return this.idx < this.expression.length() ? this.expression.substring(this.idx) : "<EOF>";
        }
    }
}

