/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.cli.javatool;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.maven.shared.utils.Os;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.shared.utils.cli.javatool.JavaTool;
import org.apache.maven.shared.utils.cli.javatool.JavaToolException;
import org.apache.maven.shared.utils.cli.javatool.JavaToolRequest;
import org.apache.maven.shared.utils.cli.javatool.JavaToolResult;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public abstract class AbstractJavaTool<Request extends JavaToolRequest>
extends AbstractLogEnabled
implements JavaTool<Request> {
    private final String javaToolName;
    private String javaToolFile;
    private Object toolchain;

    protected AbstractJavaTool(String javaToolName) {
        this.javaToolName = javaToolName;
    }

    protected abstract Commandline createCommandLine(Request var1, String var2) throws JavaToolException;

    @Override
    public String getJavaToolName() {
        return this.javaToolName;
    }

    @Override
    public void setToolchain(Object toolchain) {
        this.toolchain = toolchain;
    }

    @Override
    public JavaToolResult execute(Request request) throws JavaToolException {
        if (this.javaToolFile == null) {
            try {
                this.javaToolFile = this.findJavaToolExecutable();
            }
            catch (Exception e) {
                throw new JavaToolException("Error finding " + this.javaToolName + " executable. Reason: " + e.getMessage(), e);
            }
        }
        Commandline cli = this.createCommandLine(request, this.javaToolFile);
        JavaToolResult result2 = this.executeCommandLine(cli, request);
        return result2;
    }

    protected InputStream createSystemInputStream() {
        InputStream systemIn = new InputStream(){

            @Override
            public int read() {
                return -1;
            }
        };
        return systemIn;
    }

    protected JavaToolResult executeCommandLine(Commandline cli, Request request) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing: " + cli);
        }
        JavaToolResult result2 = this.createResult();
        result2.setCommandline(cli);
        InputStream systemIn = this.createSystemInputStream();
        StreamConsumer systemOut = this.createSystemOutStreamConsumer(request);
        StreamConsumer systemErr = this.createSystemErrorStreamConsumer(request);
        try {
            int resultCode = CommandLineUtils.executeCommandLine(cli, systemIn, systemOut, systemErr);
            result2.setExitCode(resultCode);
        }
        catch (CommandLineException e) {
            result2.setExecutionException(e);
        }
        return result2;
    }

    protected StreamConsumer createSystemErrorStreamConsumer(Request request) {
        StreamConsumer systemErr = request.getSystemErrorStreamConsumer();
        if (systemErr == null) {
            systemErr = new StreamConsumer(){

                @Override
                public void consumeLine(String line2) {
                    AbstractJavaTool.this.getLogger().warn(line2);
                }
            };
        }
        return systemErr;
    }

    protected StreamConsumer createSystemOutStreamConsumer(Request request) {
        StreamConsumer systemOut = request.getSystemOutStreamConsumer();
        if (systemOut == null) {
            systemOut = new StreamConsumer(){

                @Override
                public void consumeLine(String line2) {
                    AbstractJavaTool.this.getLogger().info(line2);
                }
            };
        }
        return systemOut;
    }

    protected JavaToolResult createResult() {
        return new JavaToolResult();
    }

    protected String findJavaToolExecutable() {
        String executable = null;
        if (this.toolchain != null) {
            executable = this.findToolchainExecutable();
        }
        String command = this.javaToolName + (Os.isFamily("windows") ? ".exe" : "");
        if (executable == null) {
            executable = this.findExecutable(command, System.getProperty("java.home"), "../bin", "bin", "../sh");
        }
        if (executable == null) {
            String variable;
            String[] variables;
            Map<String, String> env = System.getenv();
            String[] arr$ = variables = new String[]{"JDK_HOME", "JAVA_HOME"};
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (executable = this.findExecutable(command, env.get(variable = arr$[i$]), "bin", "sh")) == null; ++i$) {
            }
        }
        if (executable == null) {
            executable = command;
        }
        return executable;
    }

    private String findToolchainExecutable() {
        try {
            Method m = this.toolchain.getClass().getMethod("findTool", String.class);
            return (String)m.invoke(this.toolchain, this.javaToolName);
        }
        catch (NoSuchMethodException e) {
            this.getLogger().warn("unexpected NoSuchMethodException", e);
        }
        catch (SecurityException e) {
            this.getLogger().warn("unexpected SecurityException", e);
        }
        catch (IllegalAccessException e) {
            this.getLogger().warn("unexpected IllegalAccessException", e);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("unexpected IllegalArgumentException", e);
        }
        catch (InvocationTargetException e) {
            this.getLogger().warn("unexpected InvocationTargetException", e);
        }
        return null;
    }

    private String findExecutable(String command, String homeDir, String ... subDirs) {
        String result2 = null;
        if (StringUtils.isNotEmpty(homeDir)) {
            for (String subDir : subDirs) {
                File file = new File(new File(homeDir, subDir), command);
                if (!file.isFile()) continue;
                result2 = file.getAbsolutePath();
                break;
            }
        }
        return result2;
    }
}

