/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.shared.utils.cli.AbstractStreamHandler;

class StreamFeeder
extends AbstractStreamHandler {
    private final AtomicReference<InputStream> input;
    private final AtomicReference<OutputStream> output;
    private volatile Throwable exception;

    public StreamFeeder(InputStream input2, OutputStream output) {
        this.input = new AtomicReference<InputStream>(input2);
        this.output = new AtomicReference<OutputStream>(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.feed();
        }
        catch (Throwable e) {
            if (this.exception != null) {
                this.exception = e;
            }
        }
        finally {
            this.close();
            StreamFeeder streamFeeder = this;
            synchronized (streamFeeder) {
                this.notifyAll();
            }
        }
    }

    public void close() {
        block7: {
            OutputStream os;
            block6: {
                this.setDone();
                InputStream is = this.input.getAndSet(null);
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        if (this.exception == null) break block6;
                        this.exception = ex;
                    }
                }
            }
            if ((os = (OutputStream)this.output.getAndSet(null)) != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    if (this.exception == null) break block7;
                    this.exception = ex;
                }
            }
        }
    }

    public Throwable getException() {
        return this.exception;
    }

    private void feed() throws IOException {
        InputStream is = this.input.get();
        OutputStream os = this.output.get();
        boolean flush2 = false;
        if (is != null && os != null) {
            int data;
            while (!this.isDone() && (data = is.read()) != -1) {
                if (this.isDisabled()) continue;
                os.write(data);
                flush2 = true;
            }
            if (flush2) {
                os.flush();
            }
        }
    }
}

