/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.cli;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.maven.shared.utils.Os;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.cli.Arg;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.shell.BourneShell;
import org.apache.maven.shared.utils.cli.shell.CmdShell;
import org.apache.maven.shared.utils.cli.shell.CommandShell;
import org.apache.maven.shared.utils.cli.shell.Shell;

public class Commandline
implements Cloneable {
    private final List<Arg> arguments = new Vector<Arg>();
    private final Map<String, String> envVars = Collections.synchronizedMap(new LinkedHashMap());
    private Shell shell;

    public Commandline(Shell shell) {
        this.shell = shell;
    }

    public Commandline(String toProcess) {
        this.setDefaultShell();
        String[] tmp = new String[]{};
        try {
            tmp = CommandLineUtils.translateCommandline(toProcess);
        }
        catch (Exception e) {
            System.err.println("Error translating Commandline.");
        }
        if (tmp != null && tmp.length > 0) {
            this.setExecutable(tmp[0]);
            for (int i = 1; i < tmp.length; ++i) {
                this.createArg().setValue(tmp[i]);
            }
        }
    }

    public Commandline() {
        this.setDefaultShell();
    }

    private void setDefaultShell() {
        if (Os.isFamily("windows")) {
            if (Os.isFamily("win9x")) {
                this.setShell(new CommandShell());
            } else {
                this.setShell(new CmdShell());
            }
        } else {
            this.setShell(new BourneShell());
        }
    }

    public Arg createArg() {
        return this.createArg(false);
    }

    public Arg createArg(boolean insertAtStart) {
        Argument argument = new Argument();
        if (insertAtStart) {
            this.arguments.add(0, argument);
        } else {
            this.arguments.add(argument);
        }
        return argument;
    }

    public void setExecutable(String executable) {
        this.shell.setExecutable(executable);
    }

    public String getExecutable() {
        return this.shell.getExecutable();
    }

    public void addArguments(String ... line2) {
        for (String aLine : line2) {
            this.createArg().setValue(aLine);
        }
    }

    public void addEnvironment(String name, String value2) {
        this.envVars.put(name, value2);
    }

    public void addSystemEnvironment() {
        Properties systemEnvVars = CommandLineUtils.getSystemEnvVars();
        for (Object o : systemEnvVars.keySet()) {
            String key = (String)o;
            if (this.envVars.containsKey(key)) continue;
            this.addEnvironment(key, systemEnvVars.getProperty(key));
        }
    }

    public String[] getEnvironmentVariables() {
        this.addSystemEnvironment();
        String[] environmentVars = new String[this.envVars.size()];
        int i = 0;
        for (String name : this.envVars.keySet()) {
            String value2 = this.envVars.get(name);
            environmentVars[i] = name + "=" + value2;
            ++i;
        }
        return environmentVars;
    }

    public String[] getCommandline() {
        String[] args2 = this.getArguments();
        String executable = this.getExecutable();
        if (executable == null) {
            return args2;
        }
        String[] result2 = new String[args2.length + 1];
        result2[0] = executable;
        System.arraycopy(args2, 0, result2, 1, args2.length);
        return result2;
    }

    private String[] getShellCommandline() {
        return this.getShellCommandline(false);
    }

    private String[] getShellCommandline(boolean mask) {
        List<String> shellCommandLine = this.getShell().getShellCommandLine(this.getArguments(mask));
        return shellCommandLine.toArray(new String[shellCommandLine.size()]);
    }

    public String[] getArguments() {
        return this.getArguments(false);
    }

    public String[] getArguments(boolean mask) {
        ArrayList result2 = new ArrayList(this.arguments.size() * 2);
        for (Arg argument : this.arguments) {
            Argument arg = (Argument)argument;
            Object[] s = arg.getParts();
            if (s == null) continue;
            if (mask && arg.isMask() && s.length > 0) {
                Object[] copy2 = new String[s.length];
                Arrays.fill(copy2, "*****");
                s = copy2;
            }
            Collections.addAll(result2, s);
        }
        return result2.toArray(new String[result2.size()]);
    }

    public String toString() {
        return StringUtils.join(this.getShellCommandline(true), " ");
    }

    public Object clone() {
        throw new RuntimeException("Do we ever clone a commandline?");
    }

    public void setWorkingDirectory(String path2) {
        this.shell.setWorkingDirectory(path2);
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.shell.setWorkingDirectory(workingDirectory);
    }

    public File getWorkingDirectory() {
        return this.shell.getWorkingDirectory();
    }

    public void clearArgs() {
        this.arguments.clear();
    }

    public Process execute() throws CommandLineException {
        Process process2;
        String[] environment = this.getEnvironmentVariables();
        File workingDir = this.shell.getWorkingDirectory();
        try {
            if (workingDir == null) {
                process2 = Runtime.getRuntime().exec(this.getShellCommandline(), environment);
            } else {
                if (!workingDir.exists()) {
                    throw new CommandLineException("Working directory \"" + workingDir.getPath() + "\" does not exist!");
                }
                if (!workingDir.isDirectory()) {
                    throw new CommandLineException("Path \"" + workingDir.getPath() + "\" does not specify a directory.");
                }
                process2 = Runtime.getRuntime().exec(this.getShellCommandline(), environment, workingDir);
            }
        }
        catch (IOException ex) {
            throw new CommandLineException("Error while executing process.", ex);
        }
        return process2;
    }

    void setShell(Shell shell) {
        this.shell = shell;
    }

    public Shell getShell() {
        return this.shell;
    }

    public static class Argument
    implements Arg {
        private String[] parts;
        private boolean mask;

        @Override
        public void setValue(String value2) {
            if (value2 != null) {
                this.parts = new String[]{value2};
            }
        }

        @Override
        public void setLine(String line2) {
            if (line2 == null) {
                return;
            }
            try {
                this.parts = CommandLineUtils.translateCommandline(line2);
            }
            catch (Exception e) {
                System.err.println("Error translating Commandline.");
            }
        }

        @Override
        public void setFile(File value2) {
            this.parts = new String[]{value2.getAbsolutePath()};
        }

        @Override
        public void setMask(boolean mask) {
            this.mask = mask;
        }

        private String[] getParts() {
            return this.parts;
        }

        public boolean isMask() {
            return this.mask;
        }
    }
}

