/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import java.util.Collection;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Component(role=DependencyGraphBuilder.class)
public class DefaultDependencyGraphBuilder
extends AbstractLogEnabled
implements DependencyGraphBuilder,
Contextualizable {
    protected PlexusContainer container;

    @Override
    public DependencyNode buildDependencyGraph(ProjectBuildingRequest buildingRequest, ArtifactFilter filter2) throws DependencyGraphBuilderException {
        return this.buildDependencyGraph(buildingRequest, filter2, null);
    }

    @Override
    public DependencyNode buildDependencyGraph(ProjectBuildingRequest buildingRequest, ArtifactFilter filter2, Collection<MavenProject> reactorProjects) throws DependencyGraphBuilderException {
        try {
            String hint = DefaultDependencyGraphBuilder.isMaven31() ? "maven31" : "maven3";
            DependencyGraphBuilder effectiveGraphBuilder = (DependencyGraphBuilder)this.container.lookup(DependencyGraphBuilder.class.getCanonicalName(), hint);
            if (this.getLogger().isDebugEnabled()) {
                MavenProject project = buildingRequest.getProject();
                this.getLogger().debug("building " + hint + " dependency graph for " + project.getId() + " with " + effectiveGraphBuilder.getClass().getSimpleName());
            }
            return effectiveGraphBuilder.buildDependencyGraph(buildingRequest, filter2, reactorProjects);
        }
        catch (ComponentLookupException e) {
            throw new DependencyGraphBuilderException(e.getMessage(), e);
        }
    }

    protected static boolean isMaven31() {
        return DefaultDependencyGraphBuilder.canFindCoreClass("org.eclipse.aether.artifact.Artifact");
    }

    private static boolean canFindCoreClass(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }
}

