/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.ActivationFile;
import org.apache.maven.settings.ActivationOS;
import org.apache.maven.settings.ActivationProperty;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryBase;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.TrackableBase;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class SettingsXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public SettingsXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public SettingsXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict2) throws XmlPullParserException, IOException {
        if (strict2) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict2) throws XmlPullParserException, IOException {
        if (strict2) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue2) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue2 != null) {
            return Boolean.valueOf(defaultValue2);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict2) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict2) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict2) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict2) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict2) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict2) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict2) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict2) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict2) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict2) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict2) throws XmlPullParserException {
        if (s == null && strict2) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict2) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict2) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value2, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value2, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public Settings read(Reader reader, boolean strict2) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read(parser, strict2);
    }

    public Settings read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public Settings read(InputStream in, boolean strict2) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in), strict2);
    }

    public Settings read(InputStream in) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in));
    }

    private Activation parseActivation(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Activation activation = new Activation();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "activeByDefault", null, parsed)) {
                activation.setActiveByDefault(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "activeByDefault"), "activeByDefault", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "jdk", null, parsed)) {
                activation.setJdk(this.interpolatedTrimmed(parser.nextText(), "jdk"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "os", null, parsed)) {
                activation.setOs(this.parseActivationOS(parser, strict2));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "property", null, parsed)) {
                activation.setProperty(this.parseActivationProperty(parser, strict2));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "file", null, parsed)) {
                activation.setFile(this.parseActivationFile(parser, strict2));
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return activation;
    }

    private ActivationFile parseActivationFile(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ActivationFile activationFile = new ActivationFile();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "missing", null, parsed)) {
                activationFile.setMissing(this.interpolatedTrimmed(parser.nextText(), "missing"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "exists", null, parsed)) {
                activationFile.setExists(this.interpolatedTrimmed(parser.nextText(), "exists"));
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return activationFile;
    }

    private ActivationOS parseActivationOS(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ActivationOS activationOS = new ActivationOS();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                activationOS.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "family", null, parsed)) {
                activationOS.setFamily(this.interpolatedTrimmed(parser.nextText(), "family"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "arch", null, parsed)) {
                activationOS.setArch(this.interpolatedTrimmed(parser.nextText(), "arch"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                activationOS.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return activationOS;
    }

    private ActivationProperty parseActivationProperty(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ActivationProperty activationProperty = new ActivationProperty();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                activationProperty.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "value", null, parsed)) {
                activationProperty.setValue(this.interpolatedTrimmed(parser.nextText(), "value"));
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return activationProperty;
    }

    private IdentifiableBase parseIdentifiableBase(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        IdentifiableBase identifiableBase = new IdentifiableBase();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                identifiableBase.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return identifiableBase;
    }

    private Mirror parseMirror(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Mirror mirror = new Mirror();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "mirrorOf", null, parsed)) {
                mirror.setMirrorOf(this.interpolatedTrimmed(parser.nextText(), "mirrorOf"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                mirror.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                mirror.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "layout", null, parsed)) {
                mirror.setLayout(this.interpolatedTrimmed(parser.nextText(), "layout"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "mirrorOfLayouts", null, parsed)) {
                mirror.setMirrorOfLayouts(this.interpolatedTrimmed(parser.nextText(), "mirrorOfLayouts"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                mirror.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return mirror;
    }

    private Profile parseProfile(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String value2;
        String tagName = parser.getName();
        Profile profile = new Profile();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "activation", null, parsed)) {
                profile.setActivation(this.parseActivation(parser, strict2));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "properties", null, parsed)) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    value2 = parser.nextText().trim();
                    profile.addProperty(key, value2);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "repositories", null, parsed)) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                profile.setRepositories(repositories);
                while (parser.nextTag() == 2) {
                    if ("repository".equals(parser.getName())) {
                        repositories.add(this.parseRepository(parser, strict2));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict2);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pluginRepositories", null, parsed)) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                profile.setPluginRepositories(pluginRepositories);
                while (parser.nextTag() == 2) {
                    if ("pluginRepository".equals(parser.getName())) {
                        pluginRepositories.add(this.parseRepository(parser, strict2));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict2);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                profile.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return profile;
    }

    private Proxy parseProxy(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Proxy proxy2 = new Proxy();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "active", null, parsed)) {
                proxy2.setActive(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "active"), "active", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "protocol", null, parsed)) {
                proxy2.setProtocol(this.interpolatedTrimmed(parser.nextText(), "protocol"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "username", null, parsed)) {
                proxy2.setUsername(this.interpolatedTrimmed(parser.nextText(), "username"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "password", null, parsed)) {
                proxy2.setPassword(this.interpolatedTrimmed(parser.nextText(), "password"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "port", null, parsed)) {
                proxy2.setPort(this.getIntegerValue(this.interpolatedTrimmed(parser.nextText(), "port"), "port", parser, strict2));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "host", null, parsed)) {
                proxy2.setHost(this.interpolatedTrimmed(parser.nextText(), "host"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "nonProxyHosts", null, parsed)) {
                proxy2.setNonProxyHosts(this.interpolatedTrimmed(parser.nextText(), "nonProxyHosts"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                proxy2.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return proxy2;
    }

    private Repository parseRepository(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Repository repository = new Repository();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "releases", null, parsed)) {
                repository.setReleases(this.parseRepositoryPolicy(parser, strict2));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "snapshots", null, parsed)) {
                repository.setSnapshots(this.parseRepositoryPolicy(parser, strict2));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                repository.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                repository.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                repository.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "layout", null, parsed)) {
                repository.setLayout(this.interpolatedTrimmed(parser.nextText(), "layout"));
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return repository;
    }

    private RepositoryBase parseRepositoryBase(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        RepositoryBase repositoryBase = new RepositoryBase();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                repositoryBase.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                repositoryBase.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                repositoryBase.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "layout", null, parsed)) {
                repositoryBase.setLayout(this.interpolatedTrimmed(parser.nextText(), "layout"));
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return repositoryBase;
    }

    private RepositoryPolicy parseRepositoryPolicy(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        RepositoryPolicy repositoryPolicy = new RepositoryPolicy();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "enabled", null, parsed)) {
                repositoryPolicy.setEnabled(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "enabled"), "enabled", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "updatePolicy", null, parsed)) {
                repositoryPolicy.setUpdatePolicy(this.interpolatedTrimmed(parser.nextText(), "updatePolicy"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "checksumPolicy", null, parsed)) {
                repositoryPolicy.setChecksumPolicy(this.interpolatedTrimmed(parser.nextText(), "checksumPolicy"));
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return repositoryPolicy;
    }

    private Server parseServer(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Server server = new Server();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "username", null, parsed)) {
                server.setUsername(this.interpolatedTrimmed(parser.nextText(), "username"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "password", null, parsed)) {
                server.setPassword(this.interpolatedTrimmed(parser.nextText(), "password"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "privateKey", null, parsed)) {
                server.setPrivateKey(this.interpolatedTrimmed(parser.nextText(), "privateKey"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "passphrase", null, parsed)) {
                server.setPassphrase(this.interpolatedTrimmed(parser.nextText(), "passphrase"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "filePermissions", null, parsed)) {
                server.setFilePermissions(this.interpolatedTrimmed(parser.nextText(), "filePermissions"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directoryPermissions", null, parsed)) {
                server.setDirectoryPermissions(this.interpolatedTrimmed(parser.nextText(), "directoryPermissions"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                server.setConfiguration(Xpp3DomBuilder.build(parser, true));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                server.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return server;
    }

    private Settings parseSettings(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Settings settings2 = new Settings();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "localRepository", null, parsed)) {
                settings2.setLocalRepository(this.interpolatedTrimmed(parser.nextText(), "localRepository"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "interactiveMode", null, parsed)) {
                settings2.setInteractiveMode(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "interactiveMode"), "interactiveMode", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "usePluginRegistry", null, parsed)) {
                settings2.setUsePluginRegistry(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "usePluginRegistry"), "usePluginRegistry", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "offline", null, parsed)) {
                settings2.setOffline(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "offline"), "offline", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "proxies", null, parsed)) {
                ArrayList<Proxy> proxies = new ArrayList<Proxy>();
                settings2.setProxies(proxies);
                while (parser.nextTag() == 2) {
                    if ("proxy".equals(parser.getName())) {
                        proxies.add(this.parseProxy(parser, strict2));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict2);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "servers", null, parsed)) {
                ArrayList<Server> servers = new ArrayList<Server>();
                settings2.setServers(servers);
                while (parser.nextTag() == 2) {
                    if ("server".equals(parser.getName())) {
                        servers.add(this.parseServer(parser, strict2));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict2);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "mirrors", null, parsed)) {
                ArrayList<Mirror> mirrors = new ArrayList<Mirror>();
                settings2.setMirrors(mirrors);
                while (parser.nextTag() == 2) {
                    if ("mirror".equals(parser.getName())) {
                        mirrors.add(this.parseMirror(parser, strict2));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict2);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "profiles", null, parsed)) {
                ArrayList<Profile> profiles = new ArrayList<Profile>();
                settings2.setProfiles(profiles);
                while (parser.nextTag() == 2) {
                    if ("profile".equals(parser.getName())) {
                        profiles.add(this.parseProfile(parser, strict2));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict2);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "activeProfiles", null, parsed)) {
                ArrayList<String> activeProfiles = new ArrayList<String>();
                settings2.setActiveProfiles(activeProfiles);
                while (parser.nextTag() == 2) {
                    if ("activeProfile".equals(parser.getName())) {
                        activeProfiles.add(this.interpolatedTrimmed(parser.nextText(), "activeProfiles"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict2);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pluginGroups", null, parsed)) {
                ArrayList<String> pluginGroups = new ArrayList<String>();
                settings2.setPluginGroups(pluginGroups);
                while (parser.nextTag() == 2) {
                    if ("pluginGroup".equals(parser.getName())) {
                        pluginGroups.add(this.interpolatedTrimmed(parser.nextText(), "pluginGroups"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict2);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return settings2;
    }

    private TrackableBase parseTrackableBase(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        TrackableBase trackableBase = new TrackableBase();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict2);
        }
        return trackableBase;
    }

    private Settings read(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict2 && !"settings".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'settings' but found '" + parser.getName() + "'", parser, null);
                }
                Settings settings2 = this.parseSettings(parser, strict2);
                settings2.setModelEncoding(parser.getInputEncoding());
                return settings2;
            }
            eventType = parser.next();
        }
        throw new XmlPullParserException("Expected root element 'settings' but found no element at all: invalid XML document", parser, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

