/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.SettingsParseException;
import org.apache.maven.settings.io.SettingsReader;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=SettingsReader.class)
public class DefaultSettingsReader
implements SettingsReader {
    @Override
    public Settings read(File input2, Map<String, ?> options2) throws IOException {
        Validate.notNull(input2, "input cannot be null", new Object[0]);
        Settings settings2 = this.read(ReaderFactory.newXmlReader(input2), options2);
        return settings2;
    }

    @Override
    public Settings read(Reader input2, Map<String, ?> options2) throws IOException {
        Validate.notNull(input2, "input cannot be null", new Object[0]);
        try {
            SettingsXpp3Reader r = new SettingsXpp3Reader();
            Settings settings2 = r.read(input2, this.isStrict(options2));
            return settings2;
        }
        catch (XmlPullParserException e) {
            throw new SettingsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close(input2);
        }
    }

    @Override
    public Settings read(InputStream input2, Map<String, ?> options2) throws IOException {
        Validate.notNull(input2, "input cannot be null", new Object[0]);
        try {
            SettingsXpp3Reader r = new SettingsXpp3Reader();
            Settings settings2 = r.read(input2, this.isStrict(options2));
            return settings2;
        }
        catch (XmlPullParserException e) {
            throw new SettingsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close(input2);
        }
    }

    private boolean isStrict(Map<String, ?> options2) {
        Object value2 = options2 != null ? (Object)options2.get("org.apache.maven.settings.io.isStrict") : null;
        return value2 == null || Boolean.parseBoolean(value2.toString());
    }
}

