/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.maven.artifact.ArtifactScopeEnum;
import org.apache.maven.repository.metadata.ArtifactMetadata;
import org.apache.maven.repository.metadata.MetadataGraphEdge;
import org.apache.maven.repository.metadata.MetadataGraphVertex;
import org.apache.maven.repository.metadata.MetadataResolutionException;
import org.apache.maven.repository.metadata.MetadataTreeNode;

public class MetadataGraph {
    public static final int DEFAULT_VERTICES = 32;
    public static final int DEFAULT_EDGES = 64;
    private boolean versionedVertices = false;
    private boolean scopedVertices = false;
    MetadataGraphVertex entry;
    TreeSet<MetadataGraphVertex> vertices;
    Map<MetadataGraphVertex, List<MetadataGraphEdge>> incidentEdges;
    Map<MetadataGraphVertex, List<MetadataGraphEdge>> excidentEdges;
    ArtifactScopeEnum scope;

    public MetadataGraph(int nVertices) {
        this.init(nVertices, 2 * nVertices);
    }

    public MetadataGraph(int nVertices, int nEdges) {
        this.init(nVertices, nEdges);
    }

    public MetadataGraph(MetadataGraphVertex entry2) throws MetadataResolutionException {
        MetadataGraph.checkVertex(entry2);
        this.checkVertices(1);
        entry2.setCompareVersion(this.versionedVertices);
        entry2.setCompareScope(this.scopedVertices);
        this.vertices.add(entry2);
        this.entry = entry2;
    }

    public MetadataGraph(MetadataTreeNode tree2) throws MetadataResolutionException {
        this(tree2, false, false);
    }

    public MetadataGraph(MetadataTreeNode tree2, boolean versionedVertices, boolean scopedVertices) throws MetadataResolutionException {
        if (tree2 == null) {
            throw new MetadataResolutionException("tree is null");
        }
        this.setVersionedVertices(versionedVertices);
        this.setScopedVertices(scopedVertices);
        this.versionedVertices = scopedVertices || versionedVertices;
        this.scopedVertices = scopedVertices;
        int count = MetadataGraph.countNodes(tree2);
        this.init(count, count + count / 2);
        this.processTreeNodes(null, tree2, 0, 0);
    }

    private void processTreeNodes(MetadataGraphVertex parentVertex, MetadataTreeNode node, int depth, int pomOrder) throws MetadataResolutionException {
        if (node == null) {
            return;
        }
        MetadataGraphVertex vertex = new MetadataGraphVertex(node.md, this.versionedVertices, this.scopedVertices);
        if (!this.vertices.contains(vertex)) {
            this.vertices.add(vertex);
        }
        if (parentVertex != null) {
            ArtifactMetadata md = node.getMd();
            MetadataGraphEdge e = new MetadataGraphEdge(md.version, md.resolved, md.artifactScope, md.artifactUri, depth, pomOrder);
            this.addEdge(parentVertex, vertex, e);
        } else {
            this.entry = vertex;
        }
        MetadataTreeNode[] kids = node.getChildren();
        if (kids == null || kids.length < 1) {
            return;
        }
        for (int i = 0; i < kids.length; ++i) {
            MetadataTreeNode n = kids[i];
            this.processTreeNodes(vertex, n, depth + 1, i);
        }
    }

    public MetadataGraphVertex findVertex(ArtifactMetadata md) {
        if (md == null || this.vertices == null || this.vertices.size() < 1) {
            return null;
        }
        MetadataGraphVertex v = new MetadataGraphVertex(md);
        v.setCompareVersion(this.versionedVertices);
        v.setCompareScope(this.scopedVertices);
        for (MetadataGraphVertex gv : this.vertices) {
            if (!gv.equals(v)) continue;
            return gv;
        }
        return null;
    }

    public MetadataGraphVertex addVertex(ArtifactMetadata md) {
        if (md == null) {
            return null;
        }
        this.checkVertices();
        MetadataGraphVertex v = this.findVertex(md);
        if (v != null) {
            return v;
        }
        v = new MetadataGraphVertex(md);
        v.setCompareVersion(this.versionedVertices);
        v.setCompareScope(this.scopedVertices);
        this.vertices.add(v);
        return v;
    }

    private void init(int nVertices, int nEdges) {
        int nV = nVertices;
        if (nVertices < 1) {
            nV = 1;
        }
        this.checkVertices(nV);
        int nE = nVertices;
        if (nEdges <= nV) {
            nE = 2 * nE;
        }
        this.checkEdges(nE);
    }

    private void checkVertices() {
        this.checkVertices(32);
    }

    private void checkVertices(int nVertices) {
        if (this.vertices == null) {
            this.vertices = new TreeSet();
        }
    }

    private void checkEdges() {
        int count = 64;
        if (this.vertices != null) {
            count = this.vertices.size() + this.vertices.size() / 2;
        }
        this.checkEdges(count);
    }

    private void checkEdges(int nEdges) {
        if (this.incidentEdges == null) {
            this.incidentEdges = new HashMap<MetadataGraphVertex, List<MetadataGraphEdge>>(nEdges);
        }
        if (this.excidentEdges == null) {
            this.excidentEdges = new HashMap<MetadataGraphVertex, List<MetadataGraphEdge>>(nEdges);
        }
    }

    private static void checkVertex(MetadataGraphVertex v) throws MetadataResolutionException {
        if (v == null) {
            throw new MetadataResolutionException("null vertex");
        }
        if (v.getMd() == null) {
            throw new MetadataResolutionException("vertex without metadata");
        }
    }

    private static void checkEdge(MetadataGraphEdge e) throws MetadataResolutionException {
        if (e == null) {
            throw new MetadataResolutionException("badly formed edge");
        }
    }

    public List<MetadataGraphEdge> getEdgesBetween(MetadataGraphVertex vFrom, MetadataGraphVertex vTo) {
        List<MetadataGraphEdge> edges2 = this.getIncidentEdges(vTo);
        if (edges2 == null || edges2.isEmpty()) {
            return null;
        }
        ArrayList<MetadataGraphEdge> res = new ArrayList<MetadataGraphEdge>(edges2.size());
        for (MetadataGraphEdge e : edges2) {
            if (!e.getSource().equals(vFrom)) continue;
            res.add(e);
        }
        return res;
    }

    public MetadataGraph addEdge(MetadataGraphVertex vFrom, MetadataGraphVertex vTo, MetadataGraphEdge e) throws MetadataResolutionException {
        List<MetadataGraphEdge> inList;
        MetadataGraph.checkVertex(vFrom);
        MetadataGraph.checkVertex(vTo);
        this.checkVertices();
        MetadataGraph.checkEdge(e);
        this.checkEdges();
        e.setSource(vFrom);
        e.setTarget(vTo);
        vFrom.setCompareVersion(this.versionedVertices);
        vFrom.setCompareScope(this.scopedVertices);
        List<MetadataGraphEdge> exList = this.excidentEdges.get(vFrom);
        if (exList == null) {
            exList = new ArrayList<MetadataGraphEdge>();
            this.excidentEdges.put(vFrom, exList);
        }
        if (!exList.contains(e)) {
            exList.add(e);
        }
        if ((inList = this.incidentEdges.get(vTo)) == null) {
            inList = new ArrayList<MetadataGraphEdge>();
            this.incidentEdges.put(vTo, inList);
        }
        if (!inList.contains(e)) {
            inList.add(e);
        }
        return this;
    }

    public MetadataGraph removeVertex(MetadataGraphVertex v) {
        if (this.vertices != null && v != null) {
            this.vertices.remove(v);
        }
        if (this.incidentEdges != null) {
            this.incidentEdges.remove(v);
        }
        if (this.excidentEdges != null) {
            this.excidentEdges.remove(v);
        }
        return this;
    }

    private static int countNodes(MetadataTreeNode tree2) {
        if (tree2 == null) {
            return 0;
        }
        int count = 1;
        MetadataTreeNode[] kids = tree2.getChildren();
        if (kids == null || kids.length < 1) {
            return count;
        }
        for (MetadataTreeNode n : kids) {
            count += MetadataGraph.countNodes(n);
        }
        return count;
    }

    public MetadataGraphVertex getEntry() {
        return this.entry;
    }

    public void setEntry(MetadataGraphVertex entry2) {
        this.entry = entry2;
    }

    public TreeSet<MetadataGraphVertex> getVertices() {
        return this.vertices;
    }

    public List<MetadataGraphEdge> getIncidentEdges(MetadataGraphVertex vertex) {
        this.checkEdges();
        return this.incidentEdges.get(vertex);
    }

    public List<MetadataGraphEdge> getExcidentEdges(MetadataGraphVertex vertex) {
        this.checkEdges();
        return this.excidentEdges.get(vertex);
    }

    public boolean isVersionedVertices() {
        return this.versionedVertices;
    }

    public void setVersionedVertices(boolean versionedVertices) {
        this.versionedVertices = versionedVertices;
    }

    public boolean isScopedVertices() {
        return this.scopedVertices;
    }

    public void setScopedVertices(boolean scopedVertices) {
        this.scopedVertices = scopedVertices;
        if (scopedVertices) {
            this.versionedVertices = true;
        }
    }

    public ArtifactScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ArtifactScopeEnum scope) {
        this.scope = scope;
    }

    public boolean isEmpty() {
        return this.entry == null || this.vertices == null || this.vertices.isEmpty();
    }

    public boolean isEmptyEdges() {
        return this.isEmpty() || this.incidentEdges == null || this.incidentEdges.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        if (this.isEmpty()) {
            return "empty";
        }
        for (MetadataGraphVertex v : this.vertices) {
            sb.append("Vertex:  ").append(v.getMd().toString()).append("\n");
            List<MetadataGraphEdge> ins = this.getIncidentEdges(v);
            if (ins != null) {
                for (MetadataGraphEdge e : ins) {
                    sb.append("       from :  ").append(e.toString()).append("\n");
                }
            } else {
                sb.append("      no entries\n");
            }
            List<MetadataGraphEdge> outs = this.getExcidentEdges(v);
            if (outs != null) {
                for (MetadataGraphEdge e : outs) {
                    sb.append("        to :  ").append(e.toString()).append("\n");
                }
            } else {
                sb.append("      no exit\n");
            }
            sb.append("-------------------------------------------------\n");
        }
        sb.append("=============================================================\n");
        return sb.toString();
    }
}

