/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.legacy.resolver.transform;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformation;
import org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformationManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=ArtifactTransformationManager.class)
public class DefaultArtifactTransformationManager
implements ArtifactTransformationManager {
    @Requirement(role=ArtifactTransformation.class, hints={"release", "latest", "snapshot"})
    private List<ArtifactTransformation> artifactTransformations;

    @Override
    public void transformForResolve(Artifact artifact, RepositoryRequest request) throws ArtifactResolutionException, ArtifactNotFoundException {
        for (ArtifactTransformation transform2 : this.artifactTransformations) {
            transform2.transformForResolve(artifact, request);
        }
    }

    @Override
    public void transformForResolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        for (ArtifactTransformation transform2 : this.artifactTransformations) {
            transform2.transformForResolve(artifact, remoteRepositories, localRepository);
        }
    }

    @Override
    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        for (ArtifactTransformation transform2 : this.artifactTransformations) {
            transform2.transformForInstall(artifact, localRepository);
        }
    }

    @Override
    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        for (ArtifactTransformation transform2 : this.artifactTransformations) {
            transform2.transformForDeployment(artifact, remoteRepository, localRepository);
        }
    }

    @Override
    public List<ArtifactTransformation> getArtifactTransformations() {
        return this.artifactTransformations;
    }
}

