/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.legacy;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.maven.repository.ArtifactTransferEvent;
import org.apache.maven.repository.ArtifactTransferListener;
import org.apache.maven.repository.ArtifactTransferResource;
import org.apache.maven.repository.legacy.MavenArtifact;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;

public class TransferListenerAdapter
implements TransferListener {
    private final ArtifactTransferListener listener;
    private final Map<Resource, ArtifactTransferResource> artifacts;
    private final Map<Resource, Long> transfers;

    public static TransferListener newAdapter(ArtifactTransferListener listener) {
        if (listener == null) {
            return null;
        }
        return new TransferListenerAdapter(listener);
    }

    private TransferListenerAdapter(ArtifactTransferListener listener) {
        this.listener = listener;
        this.artifacts = new IdentityHashMap<Resource, ArtifactTransferResource>();
        this.transfers = new IdentityHashMap<Resource, Long>();
    }

    @Override
    public void debug(String message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferCompleted(TransferEvent transferEvent) {
        Long transferred;
        ArtifactTransferEvent event = this.wrap(transferEvent);
        Map<Resource, Object> map2 = this.transfers;
        synchronized (map2) {
            transferred = this.transfers.remove(transferEvent.getResource());
        }
        if (transferred != null) {
            event.setTransferredBytes(transferred);
        }
        map2 = this.artifacts;
        synchronized (map2) {
            this.artifacts.remove(transferEvent.getResource());
        }
        this.listener.transferCompleted(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferError(TransferEvent transferEvent) {
        Map<Resource, Object> map2 = this.transfers;
        synchronized (map2) {
            this.transfers.remove(transferEvent.getResource());
        }
        map2 = this.artifacts;
        synchronized (map2) {
            this.artifacts.remove(transferEvent.getResource());
        }
    }

    @Override
    public void transferInitiated(TransferEvent transferEvent) {
        this.listener.transferInitiated(this.wrap(transferEvent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
        Long transferred;
        Map<Resource, Long> map2 = this.transfers;
        synchronized (map2) {
            transferred = this.transfers.get(transferEvent.getResource());
            transferred = transferred == null ? Long.valueOf(length) : Long.valueOf(transferred + (long)length);
            this.transfers.put(transferEvent.getResource(), transferred);
        }
        ArtifactTransferEvent event = this.wrap(transferEvent);
        event.setDataBuffer(buffer);
        event.setDataOffset(0);
        event.setDataLength(length);
        event.setTransferredBytes(transferred);
        this.listener.transferProgress(event);
    }

    @Override
    public void transferStarted(TransferEvent transferEvent) {
        this.listener.transferStarted(this.wrap(transferEvent));
    }

    private ArtifactTransferEvent wrap(TransferEvent event) {
        if (event == null) {
            return null;
        }
        String wagon = event.getWagon().getClass().getName();
        ArtifactTransferResource artifact = this.wrap(event.getWagon().getRepository(), event.getResource());
        ArtifactTransferEvent evt = event.getException() != null ? new ArtifactTransferEvent(wagon, event.getException(), event.getRequestType(), artifact) : new ArtifactTransferEvent(wagon, event.getEventType(), event.getRequestType(), artifact);
        evt.setLocalFile(event.getLocalFile());
        return evt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArtifactTransferResource wrap(Repository repository, Resource resource) {
        if (resource == null) {
            return null;
        }
        Map<Resource, ArtifactTransferResource> map2 = this.artifacts;
        synchronized (map2) {
            ArtifactTransferResource artifact = this.artifacts.get(resource);
            if (artifact == null) {
                artifact = new MavenArtifact(repository.getUrl(), resource);
                this.artifacts.put(resource, artifact);
            }
            return artifact;
        }
    }
}

