/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.Validate;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.internal.impl.CacheUtils;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.util.ConfigUtils;

@Named
@Component(role=VersionResolver.class)
public class DefaultVersionResolver
implements VersionResolver,
Service {
    private static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    private static final String RELEASE = "RELEASE";
    private static final String LATEST = "LATEST";
    private static final String SNAPSHOT = "SNAPSHOT";
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement
    private MetadataResolver metadataResolver;
    @Requirement
    private SyncContextFactory syncContextFactory;
    @Requirement
    private RepositoryEventDispatcher repositoryEventDispatcher;

    public DefaultVersionResolver() {
    }

    @Inject
    DefaultVersionResolver(MetadataResolver metadataResolver, SyncContextFactory syncContextFactory, RepositoryEventDispatcher repositoryEventDispatcher, LoggerFactory loggerFactory) {
        this.setMetadataResolver(metadataResolver);
        this.setSyncContextFactory(syncContextFactory);
        this.setLoggerFactory(loggerFactory);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setMetadataResolver(locator.getService(MetadataResolver.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
    }

    public DefaultVersionResolver setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public DefaultVersionResolver setMetadataResolver(MetadataResolver metadataResolver) {
        this.metadataResolver = Validate.notNull(metadataResolver, "metadataResolver cannot be null", new Object[0]);
        return this;
    }

    public DefaultVersionResolver setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Validate.notNull(syncContextFactory, "syncContextFactory cannot be null", new Object[0]);
        return this;
    }

    public DefaultVersionResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Validate.notNull(repositoryEventDispatcher, "repositoryEventDispatcher cannot be null", new Object[0]);
        return this;
    }

    @Override
    public VersionResult resolveVersion(RepositorySystemSession session, VersionRequest request) throws VersionResolutionException {
        DefaultMetadata metadata;
        Object obj;
        RequestTrace trace2 = RequestTrace.newChild(request.getTrace(), request);
        Artifact artifact = request.getArtifact();
        String version = artifact.getVersion();
        VersionResult result2 = new VersionResult(request);
        Key cacheKey = null;
        RepositoryCache cache = session.getCache();
        if (cache != null && !ConfigUtils.getBoolean(session, false, "aether.versionResolver.noCache") && (obj = cache.get(session, cacheKey = new Key(session, request))) instanceof Record) {
            Record record2 = (Record)obj;
            result2.setVersion(record2.version);
            result2.setRepository(CacheUtils.getRepository(session, request.getRepositories(), record2.repoClass, record2.repoId));
            return result2;
        }
        if (RELEASE.equals(version)) {
            metadata = new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), MAVEN_METADATA_XML, Metadata.Nature.RELEASE);
        } else if (LATEST.equals(version)) {
            metadata = new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), MAVEN_METADATA_XML, Metadata.Nature.RELEASE_OR_SNAPSHOT);
        } else if (version.endsWith(SNAPSHOT)) {
            WorkspaceReader workspace = session.getWorkspaceReader();
            if (workspace != null && workspace.findVersions(artifact).contains(version)) {
                metadata = null;
                result2.setRepository(workspace.getRepository());
            } else {
                metadata = new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), version, MAVEN_METADATA_XML, Metadata.Nature.SNAPSHOT);
            }
        } else {
            metadata = null;
        }
        if (metadata == null) {
            result2.setVersion(version);
        } else {
            ArrayList<MetadataRequest> metadataReqs = new ArrayList<MetadataRequest>(request.getRepositories().size());
            metadataReqs.add(new MetadataRequest(metadata, null, request.getRequestContext()));
            for (RemoteRepository repository : request.getRepositories()) {
                MetadataRequest metadataRequest = new MetadataRequest(metadata, repository, request.getRequestContext());
                metadataRequest.setDeleteLocalCopyIfMissing(true);
                metadataRequest.setFavorLocalRepository(true);
                metadataRequest.setTrace(trace2);
                metadataReqs.add(metadataRequest);
            }
            List<MetadataResult> metadataResults = this.metadataResolver.resolveMetadata(session, metadataReqs);
            HashMap<String, VersionInfo> infos = new HashMap<String, VersionInfo>();
            for (MetadataResult metadataResult : metadataResults) {
                result2.addException(metadataResult.getException());
                ArtifactRepository repository = metadataResult.getRequest().getRepository();
                if (repository == null) {
                    repository = session.getLocalRepository();
                }
                Versioning v = this.readVersions(session, trace2, metadataResult.getMetadata(), repository, result2);
                this.merge(artifact, infos, v, repository);
            }
            if (RELEASE.equals(version)) {
                this.resolve(result2, infos, RELEASE);
            } else if (LATEST.equals(version)) {
                if (!this.resolve(result2, infos, LATEST)) {
                    this.resolve(result2, infos, RELEASE);
                }
                if (result2.getVersion() != null && result2.getVersion().endsWith(SNAPSHOT)) {
                    VersionRequest subRequest = new VersionRequest();
                    subRequest.setArtifact(artifact.setVersion(result2.getVersion()));
                    if (result2.getRepository() instanceof RemoteRepository) {
                        RemoteRepository r = (RemoteRepository)result2.getRepository();
                        subRequest.setRepositories(Collections.singletonList(r));
                    } else {
                        subRequest.setRepositories(request.getRepositories());
                    }
                    VersionResult subResult = this.resolveVersion(session, subRequest);
                    result2.setVersion(subResult.getVersion());
                    result2.setRepository(subResult.getRepository());
                    for (Exception exception : subResult.getExceptions()) {
                        result2.addException(exception);
                    }
                }
            } else {
                String key = SNAPSHOT + this.getKey(artifact.getClassifier(), artifact.getExtension());
                this.merge(infos, SNAPSHOT, key);
                if (!this.resolve(result2, infos, key)) {
                    result2.setVersion(version);
                }
            }
            if (StringUtils.isEmpty(result2.getVersion())) {
                throw new VersionResolutionException(result2);
            }
        }
        if (cacheKey != null && metadata != null && this.isSafelyCacheable(session, artifact)) {
            cache.put(session, cacheKey, new Record(result2.getVersion(), result2.getRepository()));
        }
        return result2;
    }

    private boolean resolve(VersionResult result2, Map<String, VersionInfo> infos, String key) {
        VersionInfo info2 = infos.get(key);
        if (info2 != null) {
            result2.setVersion(info2.version);
            result2.setRepository(info2.repository);
        }
        return info2 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Versioning readVersions(RepositorySystemSession session, RequestTrace trace2, Metadata metadata, ArtifactRepository repository, VersionResult result2) {
        Versioning versioning;
        block18: {
            versioning = null;
            FileInputStream fis = null;
            try {
                if (metadata == null) break block18;
                try (SyncContext syncContext = this.syncContextFactory.newInstance(session, true);){
                    org.apache.maven.artifact.repository.metadata.Metadata m;
                    syncContext.acquire(null, Collections.singleton(metadata));
                    if (metadata.getFile() != null && metadata.getFile().exists() && (versioning = (m = new MetadataXpp3Reader().read(fis = new FileInputStream(metadata.getFile()), false)).getVersioning()) != null && repository instanceof LocalRepository && versioning.getSnapshot() != null && versioning.getSnapshot().getBuildNumber() > 0) {
                        Versioning repaired = new Versioning();
                        repaired.setLastUpdated(versioning.getLastUpdated());
                        Snapshot snapshot2 = new Snapshot();
                        snapshot2.setLocalCopy(true);
                        repaired.setSnapshot(snapshot2);
                        versioning = repaired;
                        throw new IOException("Snapshot information corrupted with remote repository data, please verify that no remote repository uses the id '" + repository.getId() + "'");
                    }
                }
            }
            catch (Exception e) {
                this.invalidMetadata(session, trace2, metadata, repository, e);
                result2.addException(e);
            }
            finally {
                IOUtil.close(fis);
            }
        }
        return versioning != null ? versioning : new Versioning();
    }

    private void invalidMetadata(RepositorySystemSession session, RequestTrace trace2, Metadata metadata, ArtifactRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_INVALID);
        event.setTrace(trace2);
        event.setMetadata(metadata);
        event.setException(exception);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void merge(Artifact artifact, Map<String, VersionInfo> infos, Versioning versioning, ArtifactRepository repository) {
        if (StringUtils.isNotEmpty(versioning.getRelease())) {
            this.merge(RELEASE, infos, versioning.getLastUpdated(), versioning.getRelease(), repository);
        }
        if (StringUtils.isNotEmpty(versioning.getLatest())) {
            this.merge(LATEST, infos, versioning.getLastUpdated(), versioning.getLatest(), repository);
        }
        for (SnapshotVersion sv : versioning.getSnapshotVersions()) {
            if (!StringUtils.isNotEmpty(sv.getVersion())) continue;
            String key = this.getKey(sv.getClassifier(), sv.getExtension());
            this.merge(SNAPSHOT + key, infos, sv.getUpdated(), sv.getVersion(), repository);
        }
        Snapshot snapshot2 = versioning.getSnapshot();
        if (snapshot2 != null && versioning.getSnapshotVersions().isEmpty()) {
            String version = artifact.getVersion();
            if (snapshot2.getTimestamp() != null && snapshot2.getBuildNumber() > 0) {
                String qualifier = snapshot2.getTimestamp() + '-' + snapshot2.getBuildNumber();
                version = version.substring(0, version.length() - SNAPSHOT.length()) + qualifier;
            }
            this.merge(SNAPSHOT, infos, versioning.getLastUpdated(), version, repository);
        }
    }

    private void merge(String key, Map<String, VersionInfo> infos, String timestamp, String version, ArtifactRepository repository) {
        VersionInfo info2 = infos.get(key);
        if (info2 == null) {
            info2 = new VersionInfo(timestamp, version, repository);
            infos.put(key, info2);
        } else if (info2.isOutdated(timestamp)) {
            info2.version = version;
            info2.repository = repository;
            info2.timestamp = timestamp;
        }
    }

    private void merge(Map<String, VersionInfo> infos, String srcKey, String dstKey) {
        VersionInfo srcInfo = infos.get(srcKey);
        VersionInfo dstInfo = infos.get(dstKey);
        if (dstInfo == null || srcInfo != null && dstInfo.isOutdated(srcInfo.timestamp) && srcInfo.repository != dstInfo.repository) {
            infos.put(dstKey, srcInfo);
        }
    }

    private String getKey(String classifier, String extension2) {
        return StringUtils.clean(classifier) + ':' + StringUtils.clean(extension2);
    }

    private boolean isSafelyCacheable(RepositorySystemSession session, Artifact artifact) {
        WorkspaceReader workspace = session.getWorkspaceReader();
        if (workspace == null) {
            return true;
        }
        Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifact(artifact);
        return workspace.findArtifact(pomArtifact) == null;
    }

    private static class Record {
        final String version;
        final String repoId;
        final Class<?> repoClass;

        public Record(String version, ArtifactRepository repository) {
            this.version = version;
            if (repository != null) {
                this.repoId = repository.getId();
                this.repoClass = repository.getClass();
            } else {
                this.repoId = null;
                this.repoClass = null;
            }
        }
    }

    private static class Key {
        private final String groupId;
        private final String artifactId;
        private final String classifier;
        private final String extension;
        private final String version;
        private final String context;
        private final File localRepo;
        private final WorkspaceRepository workspace;
        private final List<RemoteRepository> repositories;
        private final int hashCode;

        public Key(RepositorySystemSession session, VersionRequest request) {
            Artifact artifact = request.getArtifact();
            this.groupId = artifact.getGroupId();
            this.artifactId = artifact.getArtifactId();
            this.classifier = artifact.getClassifier();
            this.extension = artifact.getExtension();
            this.version = artifact.getVersion();
            this.localRepo = session.getLocalRepository().getBasedir();
            this.workspace = CacheUtils.getWorkspace(session);
            this.repositories = new ArrayList<RemoteRepository>(request.getRepositories().size());
            boolean repoMan = false;
            for (RemoteRepository repository : request.getRepositories()) {
                if (repository.isRepositoryManager()) {
                    repoMan = true;
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            this.context = repoMan ? request.getRequestContext() : "";
            int hash2 = 17;
            hash2 = hash2 * 31 + this.groupId.hashCode();
            hash2 = hash2 * 31 + this.artifactId.hashCode();
            hash2 = hash2 * 31 + this.classifier.hashCode();
            hash2 = hash2 * 31 + this.extension.hashCode();
            hash2 = hash2 * 31 + this.version.hashCode();
            hash2 = hash2 * 31 + this.localRepo.hashCode();
            this.hashCode = hash2 = hash2 * 31 + CacheUtils.repositoriesHashCode(this.repositories);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Key that = (Key)obj;
            return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.classifier.equals(that.classifier) && this.extension.equals(that.extension) && this.version.equals(that.version) && this.context.equals(that.context) && this.localRepo.equals(that.localRepo) && CacheUtils.eq(this.workspace, that.workspace) && CacheUtils.repositoriesEquals(this.repositories, that.repositories);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class VersionInfo {
        String timestamp;
        String version;
        ArtifactRepository repository;

        public VersionInfo(String timestamp, String version, ArtifactRepository repository) {
            this.timestamp = timestamp != null ? timestamp : "";
            this.version = version;
            this.repository = repository;
        }

        public boolean isOutdated(String timestamp) {
            return timestamp != null && timestamp.compareTo(this.timestamp) > 0;
        }
    }
}

