/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.interpolation;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.interpolation.BuildTimestampValueSource;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.project.interpolation.PathTranslatingPostProcessor;
import org.apache.maven.project.path.PathTranslator;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Deprecated
public abstract class AbstractStringBasedModelInterpolator
extends AbstractLogEnabled
implements ModelInterpolator,
Initializable {
    private static final List<String> PROJECT_PREFIXES = Arrays.asList("pom.", "project.");
    private static final List<String> TRANSLATED_PATH_EXPRESSIONS;
    @Requirement
    private PathTranslator pathTranslator;
    private Interpolator interpolator;
    private RecursionInterceptor recursionInterceptor;

    protected AbstractStringBasedModelInterpolator(PathTranslator pathTranslator) {
        this.pathTranslator = pathTranslator;
    }

    protected AbstractStringBasedModelInterpolator() {
    }

    @Override
    public Model interpolate(Model model, Map<String, ?> context) throws ModelInterpolationException {
        return this.interpolate(model, context, true);
    }

    @Override
    public Model interpolate(Model model, Map<String, ?> context, boolean strict2) throws ModelInterpolationException {
        Properties props = new Properties();
        props.putAll(context);
        return this.interpolate(model, null, new DefaultProjectBuilderConfiguration().setExecutionProperties(props), true);
    }

    @Override
    public Model interpolate(Model model, File projectDir, ProjectBuilderConfiguration config, boolean debugEnabled) throws ModelInterpolationException {
        StringWriter sWriter = new StringWriter(1024);
        MavenXpp3Writer writer = new MavenXpp3Writer();
        try {
            writer.write(sWriter, model);
        }
        catch (IOException e) {
            throw new ModelInterpolationException("Cannot serialize project model for interpolation.", e);
        }
        String serializedModel = sWriter.toString();
        serializedModel = this.interpolate(serializedModel, model, projectDir, config, debugEnabled);
        StringReader sReader = new StringReader(serializedModel);
        MavenXpp3Reader modelReader = new MavenXpp3Reader();
        try {
            model = modelReader.read(sReader);
        }
        catch (IOException | XmlPullParserException e) {
            throw new ModelInterpolationException("Cannot read project model from interpolating filter of serialized version.", e);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String interpolate(String src, Model model, File projectDir, ProjectBuilderConfiguration config, boolean debug2) throws ModelInterpolationException {
        try {
            List<ValueSource> valueSources = this.createValueSources(model, projectDir, config);
            List<InterpolationPostProcessor> postProcessors = this.createPostProcessors(model, projectDir, config);
            String string2 = this.interpolateInternal(src, valueSources, postProcessors, debug2);
            return string2;
        }
        finally {
            this.interpolator.clearAnswers();
        }
    }

    protected List<ValueSource> createValueSources(Model model, final File projectDir, final ProjectBuilderConfiguration config) {
        String timestampFormat = "yyyyMMdd-HHmm";
        Properties modelProperties = model.getProperties();
        if (modelProperties != null) {
            timestampFormat = modelProperties.getProperty("maven.build.timestamp.format", timestampFormat);
        }
        PrefixedObjectValueSource modelValueSource1 = new PrefixedObjectValueSource(PROJECT_PREFIXES, model, false);
        ObjectBasedValueSource modelValueSource2 = new ObjectBasedValueSource(model);
        PrefixedValueSourceWrapper basedirValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

            @Override
            public Object getValue(String expression) {
                if (projectDir != null && "basedir".equals(expression)) {
                    return projectDir.getAbsolutePath();
                }
                return null;
            }
        }, PROJECT_PREFIXES, true);
        PrefixedValueSourceWrapper baseUriValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

            @Override
            public Object getValue(String expression) {
                if (projectDir != null && "baseUri".equals(expression)) {
                    return projectDir.getAbsoluteFile().toURI().toString();
                }
                return null;
            }
        }, PROJECT_PREFIXES, false);
        ArrayList<ValueSource> valueSources = new ArrayList<ValueSource>(9);
        valueSources.add(basedirValueSource);
        valueSources.add(baseUriValueSource);
        valueSources.add(new BuildTimestampValueSource(config.getBuildStartTime(), timestampFormat));
        valueSources.add(modelValueSource1);
        valueSources.add(new MapBasedValueSource(config.getUserProperties()));
        valueSources.add(new MapBasedValueSource(modelProperties));
        valueSources.add(new MapBasedValueSource(config.getExecutionProperties()));
        valueSources.add(new AbstractValueSource(false){

            @Override
            public Object getValue(String expression) {
                return config.getExecutionProperties().getProperty("env." + expression);
            }
        });
        valueSources.add(modelValueSource2);
        return valueSources;
    }

    protected List<InterpolationPostProcessor> createPostProcessors(Model model, File projectDir, ProjectBuilderConfiguration config) {
        return Collections.singletonList(new PathTranslatingPostProcessor(PROJECT_PREFIXES, TRANSLATED_PATH_EXPRESSIONS, projectDir, this.pathTranslator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String interpolateInternal(String src, List<ValueSource> valueSources, List<InterpolationPostProcessor> postProcessors, boolean debug2) throws ModelInterpolationException {
        if (!src.contains("${")) {
            return src;
        }
        Logger logger = this.getLogger();
        String result2 = src;
        AbstractStringBasedModelInterpolator abstractStringBasedModelInterpolator = this;
        synchronized (abstractStringBasedModelInterpolator) {
            for (ValueSource vs : valueSources) {
                this.interpolator.addValueSource(vs);
            }
            for (InterpolationPostProcessor postProcessor : postProcessors) {
                this.interpolator.addPostProcessor(postProcessor);
            }
            try {
                List feedback;
                try {
                    result2 = this.interpolator.interpolate(result2, this.recursionInterceptor);
                }
                catch (InterpolationException e) {
                    throw new ModelInterpolationException(e.getMessage(), e);
                }
                if (debug2 && (feedback = this.interpolator.getFeedback()) != null && !feedback.isEmpty()) {
                    logger.debug("Maven encountered the following problems during initial POM interpolation:");
                    Object last = null;
                    for (Object next2 : feedback) {
                        if (next2 instanceof Throwable) {
                            if (last == null) {
                                logger.debug("", (Throwable)next2);
                                continue;
                            }
                            logger.debug(String.valueOf(last), (Throwable)next2);
                            continue;
                        }
                        if (last != null) {
                            logger.debug(String.valueOf(last));
                        }
                        last = next2;
                    }
                    if (last != null) {
                        logger.debug(String.valueOf(last));
                    }
                }
                this.interpolator.clearFeedback();
            }
            catch (Throwable throwable2) {
                for (ValueSource vs : valueSources) {
                    this.interpolator.removeValuesSource(vs);
                }
                for (InterpolationPostProcessor postProcessor : postProcessors) {
                    this.interpolator.removePostProcessor(postProcessor);
                }
                throw throwable2;
            }
            for (ValueSource vs : valueSources) {
                this.interpolator.removeValuesSource(vs);
            }
            for (InterpolationPostProcessor postProcessor : postProcessors) {
                this.interpolator.removePostProcessor(postProcessor);
            }
        }
        return result2;
    }

    protected RecursionInterceptor getRecursionInterceptor() {
        return this.recursionInterceptor;
    }

    protected void setRecursionInterceptor(RecursionInterceptor recursionInterceptor) {
        this.recursionInterceptor = recursionInterceptor;
    }

    protected abstract Interpolator createInterpolator();

    @Override
    public void initialize() throws InitializationException {
        this.interpolator = this.createInterpolator();
        this.recursionInterceptor = new PrefixAwareRecursionInterceptor(PROJECT_PREFIXES);
    }

    protected final Interpolator getInterpolator() {
        return this.interpolator;
    }

    static {
        ArrayList<String> translatedPrefixes = new ArrayList<String>();
        translatedPrefixes.add("build.directory");
        translatedPrefixes.add("build.outputDirectory");
        translatedPrefixes.add("build.testOutputDirectory");
        translatedPrefixes.add("build.sourceDirectory");
        translatedPrefixes.add("build.testSourceDirectory");
        translatedPrefixes.add("build.scriptSourceDirectory");
        translatedPrefixes.add("reporting.outputDirectory");
        TRANSLATED_PATH_EXPRESSIONS = translatedPrefixes;
    }
}

