/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.activation;

import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.activation.DetectedProfileActivator;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.codehaus.plexus.util.StringUtils;

@Deprecated
public class JdkPrefixProfileActivator
extends DetectedProfileActivator {
    private static final String JDK_VERSION = System.getProperty("java.version");

    @Override
    public boolean isActive(Profile profile) throws ProfileActivationException {
        Activation activation = profile.getActivation();
        String jdk = activation.getJdk();
        if (jdk.startsWith("[") || jdk.startsWith("(")) {
            try {
                return this.matchJdkVersionRange(jdk);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new ProfileActivationException("Invalid JDK version in profile '" + profile.getId() + "': " + e.getMessage());
            }
        }
        boolean reverse2 = false;
        if (jdk.startsWith("!")) {
            reverse2 = true;
            jdk = jdk.substring(1);
        }
        if (this.getJdkVersion().startsWith(jdk)) {
            return !reverse2;
        }
        return reverse2;
    }

    private boolean matchJdkVersionRange(String jdk) throws InvalidVersionSpecificationException {
        VersionRange jdkVersionRange = VersionRange.createFromVersionSpec(this.convertJdkToMavenVersion(jdk));
        DefaultArtifactVersion jdkVersion = new DefaultArtifactVersion(this.convertJdkToMavenVersion(this.getJdkVersion()));
        return jdkVersionRange.containsVersion(jdkVersion);
    }

    private String convertJdkToMavenVersion(String jdk) {
        return jdk.replaceAll("_", "-");
    }

    protected String getJdkVersion() {
        return JDK_VERSION;
    }

    @Override
    protected boolean canDetectActivation(Profile profile) {
        return profile.getActivation() != null && StringUtils.isNotEmpty(profile.getActivation().getJdk());
    }
}

