/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.codehaus.plexus.component.configurator.ConfigurationListener;

class ValidatingConfigurationListener
implements ConfigurationListener {
    private final Object mojo;
    private final ConfigurationListener delegate;
    private final Map<String, Parameter> missingParameters;

    public ValidatingConfigurationListener(Object mojo, MojoDescriptor mojoDescriptor, ConfigurationListener delegate) {
        this.mojo = mojo;
        this.delegate = delegate;
        this.missingParameters = new HashMap<String, Parameter>();
        if (mojoDescriptor.getParameters() != null) {
            for (Parameter param2 : mojoDescriptor.getParameters()) {
                if (!param2.isRequired()) continue;
                this.missingParameters.put(param2.getName(), param2);
            }
        }
    }

    public Collection<Parameter> getMissingParameters() {
        return this.missingParameters.values();
    }

    @Override
    public void notifyFieldChangeUsingSetter(String fieldName, Object value2, Object target) {
        this.delegate.notifyFieldChangeUsingSetter(fieldName, value2, target);
        if (this.mojo == target) {
            this.notify(fieldName, value2);
        }
    }

    @Override
    public void notifyFieldChangeUsingReflection(String fieldName, Object value2, Object target) {
        this.delegate.notifyFieldChangeUsingReflection(fieldName, value2, target);
        if (this.mojo == target) {
            this.notify(fieldName, value2);
        }
    }

    private void notify(String fieldName, Object value2) {
        if (value2 != null) {
            this.missingParameters.remove(fieldName);
        }
    }
}

