/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.PathTranslator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;

public class PluginParameterExpressionEvaluator
implements TypeAwareExpressionEvaluator {
    private MavenSession session;
    private MojoExecution mojoExecution;
    private MavenProject project;
    private String basedir;
    private Properties properties;

    @Deprecated
    public PluginParameterExpressionEvaluator(MavenSession session, MojoExecution mojoExecution, PathTranslator pathTranslator, Logger logger, MavenProject project, Properties properties) {
        this(session, mojoExecution);
    }

    public PluginParameterExpressionEvaluator(MavenSession session) {
        this(session, null);
    }

    public PluginParameterExpressionEvaluator(MavenSession session, MojoExecution mojoExecution) {
        File projectFile;
        this.session = session;
        this.mojoExecution = mojoExecution;
        this.properties = new Properties();
        this.project = session.getCurrentProject();
        this.properties.putAll((Map<?, ?>)session.getUserProperties());
        this.properties.putAll((Map<?, ?>)session.getSystemProperties());
        String basedir = null;
        if (this.project != null && (projectFile = this.project.getBasedir()) != null) {
            basedir = projectFile.getAbsolutePath();
        }
        if (basedir == null) {
            basedir = session.getExecutionRootDirectory();
        }
        if (basedir == null) {
            basedir = System.getProperty("user.dir");
        }
        this.basedir = basedir;
    }

    @Override
    public Object evaluate(String expr2) throws ExpressionEvaluationException {
        return this.evaluate(expr2, null);
    }

    @Override
    public Object evaluate(String expr2, Class<?> type) throws ExpressionEvaluationException {
        String val;
        int exprStartDelimiter;
        String pathExpression;
        int pathSeparator;
        Object value2 = null;
        if (expr2 == null) {
            return null;
        }
        String expression = this.stripTokens(expr2);
        if (expression.equals(expr2)) {
            int lastIndex;
            int index = expr2.indexOf("${");
            if (index >= 0 && (lastIndex = expr2.indexOf("}", index)) >= 0) {
                Object subResult;
                String retVal = expr2.substring(0, index);
                retVal = index > 0 && expr2.charAt(index - 1) == '$' ? retVal + expr2.substring(index + 1, lastIndex + 1) : ((subResult = this.evaluate(expr2.substring(index, lastIndex + 1))) != null ? retVal + subResult : retVal + "$" + expr2.substring(index + 1, lastIndex + 1));
                retVal = retVal + this.evaluate(expr2.substring(lastIndex + 1));
                return retVal;
            }
            if (expression.contains("$$")) {
                return expression.replaceAll("\\$\\$", "\\$");
            }
            return expression;
        }
        MojoDescriptor mojoDescriptor = this.mojoExecution.getMojoDescriptor();
        if ("localRepository".equals(expression)) {
            value2 = this.session.getLocalRepository();
        } else if ("session".equals(expression)) {
            value2 = this.session;
        } else if (expression.startsWith("session")) {
            try {
                pathSeparator = expression.indexOf("/");
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(1, pathSeparator);
                    value2 = ReflectionValueExtractor.evaluate(pathExpression, this.session);
                    value2 = value2 + expression.substring(pathSeparator);
                }
                value2 = ReflectionValueExtractor.evaluate(expression.substring(1), this.session);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if ("reactorProjects".equals(expression)) {
            value2 = this.session.getProjects();
        } else if ("mojoExecution".equals(expression)) {
            value2 = this.mojoExecution;
        } else if ("project".equals(expression)) {
            value2 = this.project;
        } else if ("executedProject".equals(expression)) {
            value2 = this.project.getExecutionProject();
        } else if (expression.startsWith("project") || expression.startsWith("pom")) {
            try {
                pathSeparator = expression.indexOf("/");
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(0, pathSeparator);
                    value2 = ReflectionValueExtractor.evaluate(pathExpression, this.project);
                    value2 = value2 + expression.substring(pathSeparator);
                }
                value2 = ReflectionValueExtractor.evaluate(expression.substring(1), this.project);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if (expression.equals("repositorySystemSession")) {
            value2 = this.session.getRepositorySession();
        } else if (expression.equals("mojo")) {
            value2 = this.mojoExecution;
        } else if (expression.startsWith("mojo")) {
            try {
                pathSeparator = expression.indexOf("/");
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(1, pathSeparator);
                    value2 = ReflectionValueExtractor.evaluate(pathExpression, this.mojoExecution);
                    value2 = value2 + expression.substring(pathSeparator);
                }
                value2 = ReflectionValueExtractor.evaluate(expression.substring(1), this.mojoExecution);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if (expression.equals("plugin")) {
            value2 = mojoDescriptor.getPluginDescriptor();
        } else if (expression.startsWith("plugin")) {
            try {
                pathSeparator = expression.indexOf("/");
                PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
                if (pathSeparator > 0) {
                    String pathExpression2 = expression.substring(1, pathSeparator);
                    value2 = ReflectionValueExtractor.evaluate(pathExpression2, pluginDescriptor);
                    value2 = value2 + expression.substring(pathSeparator);
                }
                value2 = ReflectionValueExtractor.evaluate(expression.substring(1), pluginDescriptor);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if ("settings".equals(expression)) {
            value2 = this.session.getSettings();
        } else if (expression.startsWith("settings")) {
            try {
                pathSeparator = expression.indexOf("/");
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(1, pathSeparator);
                    value2 = ReflectionValueExtractor.evaluate(pathExpression, this.session.getSettings());
                    value2 = value2 + expression.substring(pathSeparator);
                }
                value2 = ReflectionValueExtractor.evaluate(expression.substring(1), this.session.getSettings());
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e);
            }
        } else if ("basedir".equals(expression)) {
            value2 = this.basedir;
        } else if (expression.startsWith("basedir") && (pathSeparator = expression.indexOf("/")) > 0) {
            value2 = this.basedir + expression.substring(pathSeparator);
        }
        if (value2 != null && type != null && !(value2 instanceof String) && !PluginParameterExpressionEvaluator.isTypeCompatible(type, value2)) {
            value2 = null;
        }
        if (value2 == null) {
            if (this.properties != null) {
                value2 = this.properties.getProperty(expression);
            }
            if (value2 == null && this.project != null && this.project.getProperties() != null) {
                value2 = this.project.getProperties().getProperty(expression);
            }
        }
        if (value2 instanceof String && (exprStartDelimiter = (val = (String)value2).indexOf("${")) >= 0) {
            value2 = exprStartDelimiter > 0 ? val.substring(0, exprStartDelimiter) + this.evaluate(val.substring(exprStartDelimiter)) : this.evaluate(val.substring(exprStartDelimiter));
        }
        return value2;
    }

    private static boolean isTypeCompatible(Class<?> type, Object value2) {
        if (type.isInstance(value2)) {
            return true;
        }
        return (type.isPrimitive() || type.getName().startsWith("java.lang.")) && value2.getClass().getName().startsWith("java.lang.");
    }

    private String stripTokens(String expr2) {
        if (expr2.startsWith("${") && expr2.indexOf("}") == expr2.length() - 1) {
            expr2 = expr2.substring(2, expr2.length() - 1);
        }
        return expr2;
    }

    @Override
    public File alignToBaseDirectory(File file) {
        if (file != null && !file.isAbsolute()) {
            file = file.getPath().startsWith(File.separator) ? file.getAbsoluteFile() : new File(new File(this.basedir, file.getPath()).toURI().normalize()).getAbsoluteFile();
        }
        return file;
    }
}

