/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.ExtensionRealmCache;
import org.apache.maven.project.ExtensionDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;

@Component(role=ExtensionRealmCache.class)
public class DefaultExtensionRealmCache
implements ExtensionRealmCache,
Disposable {
    protected final Map<ExtensionRealmCache.Key, ExtensionRealmCache.CacheRecord> cache = new ConcurrentHashMap<ExtensionRealmCache.Key, ExtensionRealmCache.CacheRecord>();

    @Override
    public ExtensionRealmCache.Key createKey(List<Artifact> extensionArtifacts) {
        return new CacheKey(extensionArtifacts);
    }

    @Override
    public ExtensionRealmCache.CacheRecord get(ExtensionRealmCache.Key key) {
        return this.cache.get(key);
    }

    @Override
    public ExtensionRealmCache.CacheRecord put(ExtensionRealmCache.Key key, ClassRealm extensionRealm, ExtensionDescriptor extensionDescriptor, List<Artifact> artifacts) {
        Validate.notNull(extensionRealm, "extensionRealm cannot be null", new Object[0]);
        if (this.cache.containsKey(key)) {
            throw new IllegalStateException("Duplicate extension realm for extension " + key);
        }
        ExtensionRealmCache.CacheRecord record2 = new ExtensionRealmCache.CacheRecord(extensionRealm, extensionDescriptor, artifacts);
        this.cache.put(key, record2);
        return record2;
    }

    @Override
    public void flush() {
        for (ExtensionRealmCache.CacheRecord record2 : this.cache.values()) {
            ClassRealm realm = record2.realm;
            try {
                realm.getWorld().disposeRealm(realm.getId());
            }
            catch (NoSuchRealmException e) {}
        }
        this.cache.clear();
    }

    @Override
    public void register(MavenProject project, ExtensionRealmCache.Key key, ExtensionRealmCache.CacheRecord record2) {
    }

    @Override
    public void dispose() {
        this.flush();
    }

    protected static class CacheKey
    implements ExtensionRealmCache.Key {
        private final List<File> files;
        private final List<Long> timestamps;
        private final List<Long> sizes;
        private final List<String> ids;
        private final int hashCode;

        public CacheKey(List<Artifact> extensionArtifacts) {
            this.files = new ArrayList<File>(extensionArtifacts.size());
            this.timestamps = new ArrayList<Long>(extensionArtifacts.size());
            this.sizes = new ArrayList<Long>(extensionArtifacts.size());
            this.ids = new ArrayList<String>(extensionArtifacts.size());
            for (Artifact artifact : extensionArtifacts) {
                File file = artifact.getFile();
                this.files.add(file);
                this.timestamps.add(file != null ? Long.valueOf(file.lastModified()) : Long.valueOf(0L));
                this.sizes.add(file != null ? Long.valueOf(file.length()) : Long.valueOf(0L));
                this.ids.add(artifact.getVersion());
            }
            this.hashCode = 31 * this.files.hashCode() + 31 * this.ids.hashCode() + 31 * this.timestamps.hashCode() + 31 * this.sizes.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return this.ids.equals(other.ids) && this.files.equals(other.files) && this.timestamps.equals(other.timestamps) && this.sizes.equals(other.sizes);
        }

        public String toString() {
            return this.files.toString();
        }
    }
}

