/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.apache.maven.execution.scope.internal.MojoExecutionScope;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.CompoundMojoExecutionListener;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginExecutionException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Component(role=BuildPluginManager.class)
public class DefaultBuildPluginManager
implements BuildPluginManager {
    @Requirement
    private MavenPluginManager mavenPluginManager;
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private MojoExecutionScope scope;
    private MojoExecutionListener mojoExecutionListener;
    @Requirement(role=MojoExecutionListener.class)
    private List<MojoExecutionListener> mojoExecutionListeners;

    public void setMojoExecutionListeners(List<MojoExecutionListener> listeners) {
        this.mojoExecutionListeners = listeners;
        this.mojoExecutionListener = new CompoundMojoExecutionListener(listeners);
    }

    @Override
    public PluginDescriptor loadPlugin(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        return this.mavenPluginManager.getPluginDescriptor(plugin, repositories, session);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeMojo(MavenSession session, MojoExecution mojoExecution) throws MojoFailureException, MojoExecutionException, PluginConfigurationException, PluginManagerException {
        ClassRealm pluginRealm;
        MavenProject project = session.getCurrentProject();
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        Mojo mojo = null;
        try {
            pluginRealm = this.getPluginRealm(session, mojoDescriptor.getPluginDescriptor());
        }
        catch (PluginResolutionException e) {
            throw new PluginExecutionException(mojoExecution, project, e);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(pluginRealm);
        MavenSession oldSession = this.legacySupport.getSession();
        this.scope.enter();
        try {
            this.scope.seed(MavenProject.class, project);
            this.scope.seed(MojoExecution.class, mojoExecution);
            mojo = this.mavenPluginManager.getConfiguredMojo(Mojo.class, session, mojoExecution);
            this.legacySupport.setSession(session);
            try {
                MojoExecutionEvent mojoExecutionEvent = new MojoExecutionEvent(session, project, mojoExecution, mojo);
                this.mojoExecutionListener.beforeMojoExecution(mojoExecutionEvent);
                mojo.execute();
                this.mojoExecutionListener.afterMojoExecutionSuccess(mojoExecutionEvent);
            }
            catch (ClassCastException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new PluginExecutionException(mojoExecution, project, e);
            }
        }
        catch (PluginContainerException e) {
            try {
                this.mojoExecutionListener.afterExecutionFailure(new MojoExecutionEvent(session, project, mojoExecution, mojo, e));
                throw new PluginExecutionException(mojoExecution, project, e);
                catch (NoClassDefFoundError e2) {
                    this.mojoExecutionListener.afterExecutionFailure(new MojoExecutionEvent(session, project, mojoExecution, mojo, e2));
                    ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                    PrintStream ps = new PrintStream(os);
                    ps.println("A required class was missing while executing " + mojoDescriptor.getId() + ": " + e2.getMessage());
                    pluginRealm.display(ps);
                    PluginContainerException wrapper = new PluginContainerException(mojoDescriptor, pluginRealm, os.toString(), (Throwable)e2);
                    throw new PluginExecutionException(mojoExecution, project, wrapper);
                }
                catch (LinkageError e3) {
                    this.mojoExecutionListener.afterExecutionFailure(new MojoExecutionEvent(session, project, mojoExecution, mojo, e3));
                    ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                    PrintStream ps = new PrintStream(os);
                    ps.println("An API incompatibility was encountered while executing " + mojoDescriptor.getId() + ": " + e3.getClass().getName() + ": " + e3.getMessage());
                    pluginRealm.display(ps);
                    PluginContainerException wrapper = new PluginContainerException(mojoDescriptor, pluginRealm, os.toString(), (Throwable)e3);
                    throw new PluginExecutionException(mojoExecution, project, wrapper);
                }
                catch (ClassCastException e4) {
                    this.mojoExecutionListener.afterExecutionFailure(new MojoExecutionEvent(session, project, mojoExecution, mojo, e4));
                    ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                    PrintStream ps = new PrintStream(os);
                    ps.println("A type incompatibility occurred while executing " + mojoDescriptor.getId() + ": " + e4.getMessage());
                    pluginRealm.display(ps);
                    throw new PluginExecutionException(mojoExecution, project, os.toString(), (Throwable)e4);
                }
                catch (RuntimeException e5) {
                    this.mojoExecutionListener.afterExecutionFailure(new MojoExecutionEvent(session, project, mojoExecution, mojo, e5));
                    throw e5;
                }
            }
            catch (Throwable throwable2) {
                this.mavenPluginManager.releaseMojo(mojo, mojoExecution);
                this.scope.exit();
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                this.legacySupport.setSession(oldSession);
                throw throwable2;
            }
        }
        this.mavenPluginManager.releaseMojo(mojo, mojoExecution);
        this.scope.exit();
        Thread.currentThread().setContextClassLoader(oldClassLoader);
        this.legacySupport.setSession(oldSession);
    }

    @Override
    public ClassRealm getPluginRealm(MavenSession session, PluginDescriptor pluginDescriptor) throws PluginResolutionException, PluginManagerException {
        ClassRealm pluginRealm = pluginDescriptor.getClassRealm();
        if (pluginRealm != null) {
            return pluginRealm;
        }
        this.mavenPluginManager.setupPluginRealm(pluginDescriptor, session, null, null, null);
        return pluginDescriptor.getClassRealm();
    }

    @Override
    public MojoDescriptor getMojoDescriptor(Plugin plugin, String goal, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException {
        return this.mavenPluginManager.getMojoDescriptor(plugin, goal, repositories, session);
    }
}

