/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3ReaderEx;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=ModelReader.class)
public class DefaultModelReader
implements ModelReader {
    @Override
    public Model read(File input2, Map<String, ?> options2) throws IOException {
        Validate.notNull(input2, "input cannot be null", new Object[0]);
        Model model = this.read(new FileInputStream(input2), options2);
        model.setPomFile(input2);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model read(Reader input2, Map<String, ?> options2) throws IOException {
        Validate.notNull(input2, "input cannot be null", new Object[0]);
        try {
            Model model = this.read(input2, this.isStrict(options2), this.getSource(options2));
            return model;
        }
        finally {
            IOUtil.close(input2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model read(InputStream input2, Map<String, ?> options2) throws IOException {
        Validate.notNull(input2, "input cannot be null", new Object[0]);
        try {
            Model model = this.read(ReaderFactory.newXmlReader(input2), this.isStrict(options2), this.getSource(options2));
            return model;
        }
        finally {
            IOUtil.close(input2);
        }
    }

    private boolean isStrict(Map<String, ?> options2) {
        Object value2 = options2 != null ? (Object)options2.get("org.apache.maven.model.io.isStrict") : null;
        return value2 == null || Boolean.parseBoolean(value2.toString());
    }

    private InputSource getSource(Map<String, ?> options2) {
        Object value2 = options2 != null ? options2.get("org.apache.maven.model.io.inputSource") : null;
        return value2;
    }

    private Model read(Reader reader, boolean strict2, InputSource source) throws IOException {
        try {
            if (source != null) {
                return new MavenXpp3ReaderEx().read(reader, strict2, source);
            }
            return new MavenXpp3Reader().read(reader, strict2);
        }
        catch (XmlPullParserException e) {
            throw new ModelParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
    }
}

