/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import org.apache.maven.model.building.ModelProblem;
import org.spark_project.guava.base.Function;
import org.spark_project.guava.base.Predicates;
import org.spark_project.guava.collect.Iterables;

public class Result<T> {
    private final boolean errors;
    private final T value;
    private final Iterable<? extends ModelProblem> problems;
    private static final Function<Result<?>, Iterable<? extends ModelProblem>> GET_PROBLEMS = new Function<Result<?>, Iterable<? extends ModelProblem>>(){

        @Override
        public Iterable<? extends ModelProblem> apply(Result<?> input2) {
            return input2.getProblems();
        }
    };

    public static <T> Result<T> success(T model) {
        return Result.success(model, Collections.emptyList());
    }

    public static <T> Result<T> success(T model, Iterable<? extends ModelProblem> problems) {
        assert (!Result.hasErrors(problems));
        return new Result<T>(false, model, problems);
    }

    public static <T> Result<T> success(T model, Result<?> ... results) {
        return Result.success(model, Iterables.concat(Iterables.transform(Arrays.asList(results), GET_PROBLEMS)));
    }

    public static <T> Result<T> error(Iterable<? extends ModelProblem> problems) {
        return Result.error(null, problems);
    }

    public static <T> Result<T> error(T model) {
        return Result.error(model, Collections.emptyList());
    }

    public static <T> Result<T> error(Result<?> result2) {
        return Result.error(result2.getProblems());
    }

    public static <T> Result<T> error(Result<?> ... results) {
        return Result.error(Iterables.concat(Iterables.transform(Arrays.asList(results), GET_PROBLEMS)));
    }

    public static <T> Result<T> error(T model, Iterable<? extends ModelProblem> problems) {
        return new Result<T>(true, model, problems);
    }

    public static <T> Result<T> newResult(T model, Iterable<? extends ModelProblem> problems) {
        return new Result<T>(Result.hasErrors(problems), model, problems);
    }

    public static <T> Result<T> addProblem(Result<T> result2, ModelProblem problem2) {
        return Result.addProblems(result2, Collections.singleton(problem2));
    }

    public static <T> Result<T> addProblems(Result<T> result2, Iterable<? extends ModelProblem> problems) {
        return new Result<T>(result2.hasErrors() || Result.hasErrors(problems), result2.get(), Iterables.concat(result2.getProblems(), problems));
    }

    public static <T> Result<T> addProblems(Result<T> result2, Result<?> ... results) {
        return Result.addProblems(result2, Iterables.concat(Iterables.transform(Arrays.asList(results), GET_PROBLEMS)));
    }

    public static <T> Result<Iterable<T>> newResultSet(Iterable<? extends Result<? extends T>> results) {
        boolean hasErrors = Iterables.any(Iterables.transform(results, new Function<Result<?>, Boolean>(){

            @Override
            public Boolean apply(Result<?> input2) {
                return input2.hasErrors();
            }
        }), Predicates.equalTo(true));
        Iterable models = Iterables.transform(results, new Function<Result<? extends T>, T>(){

            @Override
            public T apply(Result<? extends T> input2) {
                return input2.get();
            }
        });
        Iterable<? extends ModelProblem> problems = Iterables.concat(Iterables.transform(results, GET_PROBLEMS));
        return new Result(hasErrors, models, problems);
    }

    private static boolean hasErrors(Iterable<? extends ModelProblem> problems) {
        return Iterables.any(Iterables.transform(problems, new Function<ModelProblem, ModelProblem.Severity>(){

            @Override
            public ModelProblem.Severity apply(ModelProblem input2) {
                return input2.getSeverity();
            }
        }), Predicates.in(EnumSet.of(ModelProblem.Severity.ERROR, ModelProblem.Severity.FATAL)));
    }

    private Result(boolean errors, T model, Iterable<? extends ModelProblem> problems) {
        this.errors = errors;
        this.value = model;
        this.problems = problems;
    }

    public Iterable<? extends ModelProblem> getProblems() {
        return this.problems;
    }

    public T get() {
        return this.value;
    }

    public boolean hasErrors() {
        return this.errors;
    }
}

