/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuildingResult;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollectorExt;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.model.io.ModelParseException;

class DefaultModelProblemCollector
implements ModelProblemCollectorExt {
    private final ModelBuildingResult result;
    private List<ModelProblem> problems;
    private String source;
    private Model sourceModel;
    private Model rootModel;
    private Set<ModelProblem.Severity> severities = EnumSet.noneOf(ModelProblem.Severity.class);

    public DefaultModelProblemCollector(ModelBuildingResult result2) {
        this.result = result2;
        this.problems = result2.getProblems();
        for (ModelProblem problem2 : this.problems) {
            this.severities.add(problem2.getSeverity());
        }
    }

    public boolean hasFatalErrors() {
        return this.severities.contains((Object)ModelProblem.Severity.FATAL);
    }

    public boolean hasErrors() {
        return this.severities.contains((Object)ModelProblem.Severity.ERROR) || this.severities.contains((Object)ModelProblem.Severity.FATAL);
    }

    @Override
    public List<ModelProblem> getProblems() {
        return this.problems;
    }

    public void setSource(String source) {
        this.source = source;
        this.sourceModel = null;
    }

    public void setSource(Model source) {
        this.sourceModel = source;
        this.source = null;
        if (this.rootModel == null) {
            this.rootModel = source;
        }
    }

    private String getSource() {
        if (this.source == null && this.sourceModel != null) {
            this.source = ModelProblemUtils.toPath(this.sourceModel);
        }
        return this.source;
    }

    private String getModelId() {
        return ModelProblemUtils.toId(this.sourceModel);
    }

    public void setRootModel(Model rootModel) {
        this.rootModel = rootModel;
    }

    public Model getRootModel() {
        return this.rootModel;
    }

    public String getRootModelId() {
        return ModelProblemUtils.toId(this.rootModel);
    }

    public void add(ModelProblem problem2) {
        this.problems.add(problem2);
        this.severities.add(problem2.getSeverity());
    }

    public void addAll(List<ModelProblem> problems) {
        this.problems.addAll(problems);
        for (ModelProblem problem2 : problems) {
            this.severities.add(problem2.getSeverity());
        }
    }

    @Override
    public void add(ModelProblemCollectorRequest req) {
        int line2 = -1;
        int column = -1;
        String source = null;
        String modelId = null;
        if (req.getLocation() != null) {
            line2 = req.getLocation().getLineNumber();
            column = req.getLocation().getColumnNumber();
            if (req.getLocation().getSource() != null) {
                modelId = req.getLocation().getSource().getModelId();
                source = req.getLocation().getSource().getLocation();
            }
        }
        if (modelId == null) {
            modelId = this.getModelId();
            source = this.getSource();
        }
        if (line2 <= 0 && column <= 0 && req.getException() instanceof ModelParseException) {
            ModelParseException e = (ModelParseException)req.getException();
            line2 = e.getLineNumber();
            column = e.getColumnNumber();
        }
        DefaultModelProblem problem2 = new DefaultModelProblem(req.getMessage(), req.getSeverity(), req.getVersion(), source, line2, column, modelId, req.getException());
        this.add(problem2);
    }

    public ModelBuildingException newModelBuildingException() {
        ModelBuildingResult result2 = this.result;
        if (result2.getModelIds().isEmpty()) {
            DefaultModelBuildingResult tmp = new DefaultModelBuildingResult();
            tmp.setEffectiveModel(result2.getEffectiveModel());
            tmp.setProblems(this.getProblems());
            tmp.setActiveExternalProfiles(result2.getActiveExternalProfiles());
            String id = this.getRootModelId();
            tmp.addModelId(id);
            tmp.setRawModel(id, this.getRootModel());
            result2 = tmp;
        }
        return new ModelBuildingException(result2);
    }
}

