/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.ReportPlugin;

public class Reporting
implements Serializable,
Cloneable,
InputLocationTracker {
    private String excludeDefaults;
    private String outputDirectory;
    private List<ReportPlugin> plugins;
    private Map<Object, InputLocation> locations;
    Map<String, ReportPlugin> reportPluginMap;

    public void addPlugin(ReportPlugin reportPlugin) {
        this.getPlugins().add(reportPlugin);
    }

    public Reporting clone() {
        try {
            Reporting copy2 = (Reporting)super.clone();
            if (this.plugins != null) {
                copy2.plugins = new ArrayList<ReportPlugin>();
                for (ReportPlugin item : this.plugins) {
                    copy2.plugins.add(item.clone());
                }
            }
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getExcludeDefaults() {
        return this.excludeDefaults;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public List<ReportPlugin> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList<ReportPlugin>();
        }
        return this.plugins;
    }

    public void removePlugin(ReportPlugin reportPlugin) {
        this.getPlugins().remove(reportPlugin);
    }

    public void setExcludeDefaults(String excludeDefaults) {
        this.excludeDefaults = excludeDefaults;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    public void setOutputDirectory(String outputDirectory2) {
        this.outputDirectory = outputDirectory2;
    }

    public void setPlugins(List<ReportPlugin> plugins) {
        this.plugins = plugins;
    }

    public boolean isExcludeDefaults() {
        return this.excludeDefaults != null ? Boolean.parseBoolean(this.excludeDefaults) : false;
    }

    public void setExcludeDefaults(boolean excludeDefaults) {
        this.excludeDefaults = String.valueOf(excludeDefaults);
    }

    public synchronized void flushReportPluginMap() {
        this.reportPluginMap = null;
    }

    public synchronized Map<String, ReportPlugin> getReportPluginsAsMap() {
        if (this.reportPluginMap == null) {
            this.reportPluginMap = new LinkedHashMap<String, ReportPlugin>();
            if (this.getPlugins() != null) {
                for (ReportPlugin reportPlugin : this.getPlugins()) {
                    this.reportPluginMap.put(reportPlugin.getKey(), reportPlugin);
                }
            }
        }
        return this.reportPluginMap;
    }
}

