/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;

public class Extension
implements Serializable,
Cloneable,
InputLocationTracker {
    private String groupId;
    private String artifactId;
    private String version;
    private Map<Object, InputLocation> locations;

    public Extension clone() {
        try {
            Extension copy2 = (Extension)super.clone();
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public String getVersion() {
        return this.version;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Extension)) {
            return false;
        }
        Extension e = (Extension)o;
        if (!Extension.equal(e.getArtifactId(), this.getArtifactId())) {
            return false;
        }
        if (!Extension.equal(e.getGroupId(), this.getGroupId())) {
            return false;
        }
        return Extension.equal(e.getVersion(), this.getVersion());
    }

    private static <T> boolean equal(T obj1, T obj2) {
        return obj1 != null ? obj1.equals(obj2) : obj2 == null;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + (this.getArtifactId() != null ? this.getArtifactId().hashCode() : 0);
        result2 = 37 * result2 + (this.getGroupId() != null ? this.getGroupId().hashCode() : 0);
        result2 = 37 * result2 + (this.getVersion() != null ? this.getVersion().hashCode() : 0);
        return result2;
    }
}

