/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal.builder.multithreaded;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ProjectSegment;

public class ThreadOutputMuxer {
    private final Iterator<ProjectSegment> projects;
    private final ThreadLocal<ProjectSegment> projectBuildThreadLocal = new ThreadLocal();
    private final Map<ProjectSegment, ByteArrayOutputStream> streams = new HashMap<ProjectSegment, ByteArrayOutputStream>();
    private final Map<ProjectSegment, PrintStream> printStreams = new HashMap<ProjectSegment, PrintStream>();
    private final ByteArrayOutputStream defaultOutputStreamForUnknownData = new ByteArrayOutputStream();
    private final PrintStream defaultPringStream = new PrintStream(this.defaultOutputStreamForUnknownData);
    private final Set<ProjectSegment> completedBuilds = Collections.synchronizedSet(new HashSet());
    private volatile ProjectSegment currentBuild;
    private final PrintStream originalSystemOUtStream;
    private final ConsolePrinter printer;

    public ThreadOutputMuxer(ProjectBuildList segmentChunks, PrintStream originalSystemOut) {
        this.projects = segmentChunks.iterator();
        for (ProjectSegment segmentChunk : segmentChunks) {
            ByteArrayOutputStream value2 = new ByteArrayOutputStream();
            this.streams.put(segmentChunk, value2);
            this.printStreams.put(segmentChunk, new PrintStream(value2));
        }
        this.setNext();
        this.originalSystemOUtStream = originalSystemOut;
        System.setOut(new ThreadBoundPrintStream(this.originalSystemOUtStream));
        this.printer = new ConsolePrinter(segmentChunks);
        new Thread(this.printer).start();
        this.printer.waitUntilRunning(true);
    }

    public void close() {
        this.printer.waitUntilRunning(false);
        System.setOut(this.originalSystemOUtStream);
    }

    private void setNext() {
        this.currentBuild = this.projects.hasNext() ? this.projects.next() : null;
    }

    private boolean ownsRealOutputStream(ProjectSegment projectBuild) {
        return projectBuild.equals(this.currentBuild);
    }

    private PrintStream getThreadBoundPrintStream() {
        ProjectSegment threadProject = this.projectBuildThreadLocal.get();
        if (threadProject == null) {
            return this.defaultPringStream;
        }
        if (this.ownsRealOutputStream(threadProject)) {
            return this.originalSystemOUtStream;
        }
        return this.printStreams.get(threadProject);
    }

    public void associateThreadWithProjectSegment(ProjectSegment projectBuild) {
        this.projectBuildThreadLocal.set(projectBuild);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThisModuleComplete(ProjectSegment projectBuild) {
        PrintStream stream;
        this.completedBuilds.add(projectBuild);
        PrintStream printStream = stream = this.printStreams.get(projectBuild);
        synchronized (printStream) {
            stream.notifyAll();
        }
        this.disconnectThreadFromProject();
    }

    private void disconnectThreadFromProject() {
        this.projectBuildThreadLocal.remove();
    }

    private class ThreadBoundPrintStream
    extends PrintStream {
        public ThreadBoundPrintStream(PrintStream systemOutStream) {
            super(systemOutStream);
        }

        private PrintStream getOutputStreamForCurrentThread() {
            return ThreadOutputMuxer.this.getThreadBoundPrintStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println() {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.println();
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(char c) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.print(c);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(char x) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.println(x);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(double d) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.print(d);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(double x) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.println(x);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(float f2) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.print(f2);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(float x) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.println(x);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(int i) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.print(i);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(int x) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.println(x);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(long l) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.print(l);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(long x) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.print(x);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(boolean b) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.print(b);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(boolean x) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.print(x);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(char[] s) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.print(s);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(char[] x) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.print(x);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(Object obj) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.print(obj);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(Object x) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.println(x);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(String s) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.print(s);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(String x) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.println(x);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.write(b, off, len);
                currentStream.notifyAll();
            }
        }

        @Override
        public void close() {
            this.getOutputStreamForCurrentThread().close();
        }

        @Override
        public void flush() {
            this.getOutputStreamForCurrentThread().flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.write(b);
                currentStream.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b) throws IOException {
            PrintStream currentStream;
            PrintStream printStream = currentStream = this.getOutputStreamForCurrentThread();
            synchronized (printStream) {
                currentStream.write(b);
                currentStream.notifyAll();
            }
        }
    }

    class ConsolePrinter
    implements Runnable {
        public volatile boolean running;
        private final ProjectBuildList projectBuildList;

        ConsolePrinter(ProjectBuildList projectBuildList) {
            this.projectBuildList = projectBuildList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.running = true;
            for (ProjectSegment projectBuild : this.projectBuildList) {
                PrintStream projectStream = (PrintStream)ThreadOutputMuxer.this.printStreams.get(projectBuild);
                ByteArrayOutputStream projectOs = (ByteArrayOutputStream)ThreadOutputMuxer.this.streams.get(projectBuild);
                do {
                    PrintStream printStream = projectStream;
                    synchronized (printStream) {
                        try {
                            projectStream.wait(100L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        try {
                            projectOs.writeTo(ThreadOutputMuxer.this.originalSystemOUtStream);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        projectOs.reset();
                    }
                } while (!ThreadOutputMuxer.this.completedBuilds.contains(projectBuild));
            }
            this.running = false;
        }

        public void waitUntilRunning(boolean expect) {
            while (!this.running == expect) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

