/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.internal.ProjectArtifactFactory;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;

@Named
public class LifecycleDependencyResolver {
    @Inject
    private ProjectDependenciesResolver dependenciesResolver;
    @Inject
    private Logger logger;
    @Inject
    private ProjectArtifactFactory artifactFactory;
    @Inject
    private EventSpyDispatcher eventSpyDispatcher;

    public LifecycleDependencyResolver() {
    }

    public LifecycleDependencyResolver(ProjectDependenciesResolver projectDependenciesResolver, Logger logger) {
        this.dependenciesResolver = projectDependenciesResolver;
        this.logger = logger;
    }

    public static List<MavenProject> getProjects(MavenProject project, MavenSession session, boolean aggregator) {
        if (aggregator) {
            return session.getProjects();
        }
        return Collections.singletonList(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveProjectDependencies(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session, boolean aggregating, Set<org.apache.maven.artifact.Artifact> projectArtifacts) throws LifecycleExecutionException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            ClassRealm projectRealm = project.getClassRealm();
            if (projectRealm != null && projectRealm != tccl) {
                Thread.currentThread().setContextClassLoader(projectRealm);
            }
            if (project.getDependencyArtifacts() == null) {
                try {
                    project.setDependencyArtifacts(this.artifactFactory.createArtifacts(project));
                }
                catch (InvalidDependencyVersionException e) {
                    throw new LifecycleExecutionException(e);
                }
            }
            Set<org.apache.maven.artifact.Artifact> artifacts = this.getDependencies(project, scopesToCollect, scopesToResolve, session, aggregating, projectArtifacts);
            project.setResolvedArtifacts(artifacts);
            HashMap<String, org.apache.maven.artifact.Artifact> map2 = new HashMap<String, org.apache.maven.artifact.Artifact>();
            for (org.apache.maven.artifact.Artifact artifact : artifacts) {
                map2.put(artifact.getDependencyConflictId(), artifact);
            }
            for (org.apache.maven.artifact.Artifact artifact : project.getDependencyArtifacts()) {
                org.apache.maven.artifact.Artifact resolved;
                if (artifact.getFile() != null || (resolved = (org.apache.maven.artifact.Artifact)map2.get(artifact.getDependencyConflictId())) == null) continue;
                artifact.setFile(resolved.getFile());
                artifact.setDependencyTrail(resolved.getDependencyTrail());
                artifact.setResolvedVersion(resolved.getVersion());
                artifact.setResolved(true);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private Set<org.apache.maven.artifact.Artifact> getDependencies(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session, boolean aggregating, Set<org.apache.maven.artifact.Artifact> projectArtifacts) throws LifecycleExecutionException {
        DependencyResolutionResult result2;
        if (scopesToCollect == null) {
            scopesToCollect = Collections.emptySet();
        }
        if (scopesToResolve == null) {
            scopesToResolve = Collections.emptySet();
        }
        if (scopesToCollect.isEmpty() && scopesToResolve.isEmpty()) {
            return new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        }
        scopesToCollect = new HashSet<String>(scopesToCollect);
        scopesToCollect.addAll(scopesToResolve);
        ScopeDependencyFilter collectionFilter = new ScopeDependencyFilter(null, this.negate(scopesToCollect));
        DependencyFilter resolutionFilter = new ScopeDependencyFilter(null, this.negate(scopesToResolve));
        resolutionFilter = AndDependencyFilter.newInstance(collectionFilter, resolutionFilter);
        resolutionFilter = AndDependencyFilter.newInstance(resolutionFilter, new ReactorDependencyFilter(projectArtifacts));
        try {
            DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest(project, session.getRepositorySession());
            request.setResolutionFilter(resolutionFilter);
            this.eventSpyDispatcher.onEvent(request);
            result2 = this.dependenciesResolver.resolve(request);
        }
        catch (DependencyResolutionException e) {
            result2 = e.getResult();
            if (aggregating && this.areAllDependenciesInReactor(session.getProjects(), result2.getUnresolvedDependencies())) {
                this.logger.warn("The following dependencies could not be resolved at this point of the build but seem to be part of the reactor:");
                for (Dependency dependency : result2.getUnresolvedDependencies()) {
                    this.logger.warn("o " + dependency);
                }
                this.logger.warn("Try running the build up to the lifecycle phase \"package\"");
            }
            throw new LifecycleExecutionException(null, project, e);
        }
        this.eventSpyDispatcher.onEvent(result2);
        LinkedHashSet<org.apache.maven.artifact.Artifact> artifacts = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        if (result2.getDependencyGraph() != null && !result2.getDependencyGraph().getChildren().isEmpty()) {
            RepositoryUtils.toArtifacts(artifacts, result2.getDependencyGraph().getChildren(), Collections.singletonList(project.getArtifact().getId()), collectionFilter);
        }
        return artifacts;
    }

    private boolean areAllDependenciesInReactor(Collection<MavenProject> projects, Collection<Dependency> dependencies) {
        Set<String> projectKeys = this.getReactorProjectKeys(projects);
        for (Dependency dependency : dependencies) {
            Artifact a = dependency.getArtifact();
            String key = ArtifactUtils.key(a.getGroupId(), a.getArtifactId(), a.getVersion());
            if (projectKeys.contains(key)) continue;
            return false;
        }
        return true;
    }

    private Set<String> getReactorProjectKeys(Collection<MavenProject> projects) {
        HashSet<String> projectKeys = new HashSet<String>(projects.size() * 2);
        for (MavenProject project : projects) {
            String key = ArtifactUtils.key(project.getGroupId(), project.getArtifactId(), project.getVersion());
            projectKeys.add(key);
        }
        return projectKeys;
    }

    private Collection<String> negate(Collection<String> scopes) {
        HashSet<String> result2 = new HashSet<String>();
        Collections.addAll(result2, "system", "compile", "provided", "runtime", "test");
        for (String scope : scopes) {
            if ("compile".equals(scope)) {
                result2.remove("compile");
                result2.remove("system");
                result2.remove("provided");
                continue;
            }
            if ("runtime".equals(scope)) {
                result2.remove("compile");
                result2.remove("runtime");
                continue;
            }
            if ("compile+runtime".equals(scope)) {
                result2.remove("compile");
                result2.remove("system");
                result2.remove("provided");
                result2.remove("runtime");
                continue;
            }
            if ("runtime+system".equals(scope)) {
                result2.remove("compile");
                result2.remove("system");
                result2.remove("runtime");
                continue;
            }
            if (!"test".equals(scope)) continue;
            result2.clear();
        }
        return result2;
    }

    private static class ReactorDependencyFilter
    implements DependencyFilter {
        private Set<String> keys = new HashSet<String>();

        public ReactorDependencyFilter(Collection<org.apache.maven.artifact.Artifact> artifacts) {
            for (org.apache.maven.artifact.Artifact artifact : artifacts) {
                String key = ArtifactUtils.key(artifact);
                this.keys.add(key);
            }
        }

        @Override
        public boolean accept(DependencyNode node, List<DependencyNode> parents2) {
            Dependency dependency = node.getDependency();
            if (dependency != null) {
                Artifact a = dependency.getArtifact();
                String key = ArtifactUtils.key(a.getGroupId(), a.getArtifactId(), a.getVersion());
                return !this.keys.contains(key);
            }
            return false;
        }
    }
}

