/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleMappingDelegate;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=LifecycleMappingDelegate.class, hint="default")
public class DefaultLifecycleMappingDelegate
implements LifecycleMappingDelegate {
    public static final String HINT = "default";
    @Requirement
    private BuildPluginManager pluginManager;

    @Override
    public Map<String, List<MojoExecution>> calculateLifecycleMappings(MavenSession session, MavenProject project, Lifecycle lifecycle, String lifecyclePhase) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException {
        LinkedHashMap mappings = new LinkedHashMap();
        for (String phase : lifecycle.getPhases()) {
            TreeMap phaseBindings = new TreeMap();
            mappings.put(phase, phaseBindings);
            if (!phase.equals(lifecyclePhase)) continue;
            break;
        }
        for (Plugin plugin : project.getBuild().getPlugins()) {
            for (PluginExecution execution : plugin.getExecutions()) {
                if (execution.getPhase() != null) {
                    Map phaseBindings = (Map)mappings.get(execution.getPhase());
                    if (phaseBindings == null) continue;
                    for (String goal : execution.getGoals()) {
                        MojoExecution mojoExecution = new MojoExecution(plugin, goal, execution.getId());
                        mojoExecution.setLifecyclePhase(execution.getPhase());
                        this.addMojoExecution(phaseBindings, mojoExecution, execution.getPriority());
                    }
                    continue;
                }
                for (String goal : execution.getGoals()) {
                    MojoDescriptor mojoDescriptor = this.pluginManager.getMojoDescriptor(plugin, goal, project.getRemotePluginRepositories(), session.getRepositorySession());
                    Map phaseBindings = (Map)mappings.get(mojoDescriptor.getPhase());
                    if (phaseBindings == null) continue;
                    MojoExecution mojoExecution = new MojoExecution(mojoDescriptor, execution.getId());
                    mojoExecution.setLifecyclePhase(mojoDescriptor.getPhase());
                    this.addMojoExecution(phaseBindings, mojoExecution, execution.getPriority());
                }
            }
        }
        LinkedHashMap<String, List<MojoExecution>> lifecycleMappings = new LinkedHashMap<String, List<MojoExecution>>();
        for (Map.Entry entry2 : mappings.entrySet()) {
            ArrayList mojoExecutions = new ArrayList();
            for (List executions : ((Map)entry2.getValue()).values()) {
                mojoExecutions.addAll(executions);
            }
            lifecycleMappings.put((String)entry2.getKey(), mojoExecutions);
        }
        return lifecycleMappings;
    }

    private void addMojoExecution(Map<Integer, List<MojoExecution>> phaseBindings, MojoExecution mojoExecution, int priority) {
        List<MojoExecution> mojoExecutions = phaseBindings.get(priority);
        if (mojoExecutions == null) {
            mojoExecutions = new ArrayList<MojoExecution>();
            phaseBindings.put(priority, mojoExecutions);
        }
        mojoExecutions.add(mojoExecution);
    }
}

