/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.MavenProject;

class FilteredProjectDependencyGraph
implements ProjectDependencyGraph {
    private ProjectDependencyGraph projectDependencyGraph;
    private Map<MavenProject, ?> whiteList;
    private List<MavenProject> sortedProjects;

    public FilteredProjectDependencyGraph(ProjectDependencyGraph projectDependencyGraph, Collection<? extends MavenProject> whiteList) {
        this.projectDependencyGraph = Validate.notNull(projectDependencyGraph, "projectDependencyGraph cannot be null", new Object[0]);
        this.whiteList = new IdentityHashMap();
        for (MavenProject mavenProject : whiteList) {
            this.whiteList.put(mavenProject, null);
        }
    }

    @Override
    public List<MavenProject> getSortedProjects() {
        if (this.sortedProjects == null) {
            this.sortedProjects = this.applyFilter(this.projectDependencyGraph.getSortedProjects());
        }
        return new ArrayList<MavenProject>(this.sortedProjects);
    }

    @Override
    public List<MavenProject> getDownstreamProjects(MavenProject project, boolean transitive2) {
        return this.applyFilter(this.projectDependencyGraph.getDownstreamProjects(project, transitive2));
    }

    @Override
    public List<MavenProject> getUpstreamProjects(MavenProject project, boolean transitive2) {
        return this.applyFilter(this.projectDependencyGraph.getUpstreamProjects(project, transitive2));
    }

    private List<MavenProject> applyFilter(Collection<? extends MavenProject> projects) {
        ArrayList<MavenProject> filtered2 = new ArrayList<MavenProject>(projects.size());
        for (MavenProject mavenProject : projects) {
            if (!this.whiteList.containsKey(mavenProject)) continue;
            filtered2.add(mavenProject);
        }
        return filtered2;
    }

    public String toString() {
        return this.getSortedProjects().toString();
    }
}

