/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectSorter;
import org.codehaus.plexus.util.dag.CycleDetectedException;

public class DefaultProjectDependencyGraph
implements ProjectDependencyGraph {
    private ProjectSorter sorter;

    public DefaultProjectDependencyGraph(Collection<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        this.sorter = new ProjectSorter(projects);
    }

    @Override
    public List<MavenProject> getSortedProjects() {
        return new ArrayList<MavenProject>(this.sorter.getSortedProjects());
    }

    @Override
    public List<MavenProject> getDownstreamProjects(MavenProject project, boolean transitive2) {
        Validate.notNull(project, "project cannot be null", new Object[0]);
        HashSet<String> projectIds = new HashSet<String>();
        this.getDownstreamProjects(ProjectSorter.getId(project), projectIds, transitive2);
        return this.getSortedProjects(projectIds);
    }

    private void getDownstreamProjects(String projectId, Set<String> projectIds, boolean transitive2) {
        for (String id : this.sorter.getDependents(projectId)) {
            if (!projectIds.add(id) || !transitive2) continue;
            this.getDownstreamProjects(id, projectIds, transitive2);
        }
    }

    @Override
    public List<MavenProject> getUpstreamProjects(MavenProject project, boolean transitive2) {
        Validate.notNull(project, "project cannot be null", new Object[0]);
        HashSet<String> projectIds = new HashSet<String>();
        this.getUpstreamProjects(ProjectSorter.getId(project), projectIds, transitive2);
        return this.getSortedProjects(projectIds);
    }

    private void getUpstreamProjects(String projectId, Collection<String> projectIds, boolean transitive2) {
        for (String id : this.sorter.getDependencies(projectId)) {
            if (!projectIds.add(id) || !transitive2) continue;
            this.getUpstreamProjects(id, projectIds, transitive2);
        }
    }

    private List<MavenProject> getSortedProjects(Set<String> projectIds) {
        ArrayList<MavenProject> result2 = new ArrayList<MavenProject>(projectIds.size());
        for (MavenProject mavenProject : this.sorter.getSortedProjects()) {
            if (!projectIds.contains(ProjectSorter.getId(mavenProject))) continue;
            result2.add(mavenProject);
        }
        return result2;
    }

    public String toString() {
        return this.sorter.getSortedProjects().toString();
    }
}

