/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.transform;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.transform.ArtifactTransformation;
import org.apache.maven.artifact.transform.ArtifactTransformationManager;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArtifactTransformationManager
implements ArtifactTransformationManager,
Initializable {
    private List<ArtifactTransformation> artifactTransformations;

    @Override
    public void initialize() throws InitializationException {
        ArtifactTransformation[] transforms = this.artifactTransformations.toArray(new ArtifactTransformation[0]);
        for (int x = 0; x < transforms.length; ++x) {
            if (transforms[x].getClass().getName().indexOf("Snapshot") == -1) continue;
            this.artifactTransformations.remove(transforms[x]);
            this.artifactTransformations.add(transforms[x]);
        }
    }

    public void transformForResolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        for (ArtifactTransformation transform2 : this.artifactTransformations) {
            transform2.transformForResolve(artifact, remoteRepositories, localRepository);
        }
    }

    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        for (ArtifactTransformation transform2 : this.artifactTransformations) {
            transform2.transformForInstall(artifact, localRepository);
        }
    }

    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        for (ArtifactTransformation transform2 : this.artifactTransformations) {
            transform2.transformForDeployment(artifact, remoteRepository, localRepository);
        }
    }
}

