/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver.filter;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

public class OrArtifactFilter
implements ArtifactFilter {
    private Set<ArtifactFilter> filters;

    public OrArtifactFilter() {
        this.filters = new LinkedHashSet<ArtifactFilter>();
    }

    public OrArtifactFilter(Collection<ArtifactFilter> filters) {
        this.filters = new LinkedHashSet<ArtifactFilter>(filters);
    }

    @Override
    public boolean include(Artifact artifact) {
        for (ArtifactFilter filter2 : this.filters) {
            if (!filter2.include(artifact)) continue;
            return true;
        }
        return false;
    }

    public void add(ArtifactFilter artifactFilter) {
        this.filters.add(artifactFilter);
    }

    public int hashCode() {
        int hash2 = 17;
        hash2 = hash2 * 31 + this.filters.hashCode();
        return hash2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OrArtifactFilter)) {
            return false;
        }
        OrArtifactFilter other = (OrArtifactFilter)obj;
        return this.filters.equals(other.filters);
    }
}

