/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MetadataXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public MetadataXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public MetadataXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict2) throws XmlPullParserException, IOException {
        if (strict2) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict2) throws XmlPullParserException, IOException {
        if (strict2) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue2) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue2 != null) {
            return Boolean.valueOf(defaultValue2);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict2) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict2) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict2) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict2) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict2) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict2) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict2) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict2) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict2) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict2) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict2) throws XmlPullParserException {
        if (s == null && strict2) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict2) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict2) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value2, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value2, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public Metadata read(Reader reader, boolean strict2) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read(parser, strict2);
    }

    public Metadata read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public Metadata read(InputStream in, boolean strict2) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in), strict2);
    }

    public Metadata read(InputStream in) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in));
    }

    private Metadata parseMetadata(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Metadata metadata = new Metadata();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            if ("modelVersion".equals(name)) {
                metadata.setModelVersion(this.interpolatedTrimmed(value2, "modelVersion"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                metadata.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                metadata.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                metadata.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "versioning", null, parsed)) {
                metadata.setVersioning(this.parseVersioning(parser, strict2));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                metadata.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if ("plugin".equals(parser.getName())) {
                        plugins.add(this.parsePlugin(parser, strict2));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict2);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return metadata;
    }

    private Plugin parsePlugin(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Plugin plugin = new Plugin();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                plugin.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "prefix", null, parsed)) {
                plugin.setPrefix(this.interpolatedTrimmed(parser.nextText(), "prefix"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                plugin.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return plugin;
    }

    private Snapshot parseSnapshot(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Snapshot snapshot2 = new Snapshot();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "timestamp", null, parsed)) {
                snapshot2.setTimestamp(this.interpolatedTrimmed(parser.nextText(), "timestamp"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "buildNumber", null, parsed)) {
                snapshot2.setBuildNumber(this.getIntegerValue(this.interpolatedTrimmed(parser.nextText(), "buildNumber"), "buildNumber", parser, strict2));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "localCopy", null, parsed)) {
                snapshot2.setLocalCopy(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "localCopy"), "localCopy", parser, "false"));
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return snapshot2;
    }

    private SnapshotVersion parseSnapshotVersion(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        SnapshotVersion snapshotVersion = new SnapshotVersion();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "classifier", null, parsed)) {
                snapshotVersion.setClassifier(this.interpolatedTrimmed(parser.nextText(), "classifier"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "extension", null, parsed)) {
                snapshotVersion.setExtension(this.interpolatedTrimmed(parser.nextText(), "extension"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "value", null, parsed)) {
                snapshotVersion.setVersion(this.interpolatedTrimmed(parser.nextText(), "value"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "updated", null, parsed)) {
                snapshotVersion.setUpdated(this.interpolatedTrimmed(parser.nextText(), "updated"));
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return snapshotVersion;
    }

    private Versioning parseVersioning(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Versioning versioning = new Versioning();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value2 = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict2);
        }
        HashSet parsed = new HashSet();
        while ((strict2 ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "latest", null, parsed)) {
                versioning.setLatest(this.interpolatedTrimmed(parser.nextText(), "latest"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "release", null, parsed)) {
                versioning.setRelease(this.interpolatedTrimmed(parser.nextText(), "release"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "snapshot", null, parsed)) {
                versioning.setSnapshot(this.parseSnapshot(parser, strict2));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "versions", null, parsed)) {
                ArrayList<String> versions = new ArrayList<String>();
                versioning.setVersions(versions);
                while (parser.nextTag() == 2) {
                    if ("version".equals(parser.getName())) {
                        versions.add(this.interpolatedTrimmed(parser.nextText(), "versions"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict2);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lastUpdated", null, parsed)) {
                versioning.setLastUpdated(this.interpolatedTrimmed(parser.nextText(), "lastUpdated"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "snapshotVersions", null, parsed)) {
                ArrayList<SnapshotVersion> snapshotVersions = new ArrayList<SnapshotVersion>();
                versioning.setSnapshotVersions(snapshotVersions);
                while (parser.nextTag() == 2) {
                    if ("snapshotVersion".equals(parser.getName())) {
                        snapshotVersions.add(this.parseSnapshotVersion(parser, strict2));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict2);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict2);
        }
        return versioning;
    }

    private Metadata read(XmlPullParser parser, boolean strict2) throws IOException, XmlPullParserException {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict2 && !"metadata".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'metadata' but found '" + parser.getName() + "'", parser, null);
                }
                Metadata metadata = this.parseMetadata(parser, strict2);
                metadata.setModelEncoding(parser.getInputEncoding());
                return metadata;
            }
            eventType = parser.next();
        }
        throw new XmlPullParserException("Expected root element 'metadata' but found no element at all: invalid XML document", parser, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

