/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.MetadataParseException;
import org.apache.maven.artifact.repository.metadata.io.MetadataReader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=MetadataReader.class)
public class DefaultMetadataReader
implements MetadataReader {
    @Override
    public Metadata read(File input2, Map<String, ?> options2) throws IOException {
        Validate.notNull(input2, "input cannot be null", new Object[0]);
        Metadata metadata = this.read(ReaderFactory.newXmlReader(input2), options2);
        return metadata;
    }

    @Override
    public Metadata read(Reader input2, Map<String, ?> options2) throws IOException {
        Validate.notNull(input2, "input cannot be null", new Object[0]);
        try {
            MetadataXpp3Reader r = new MetadataXpp3Reader();
            Metadata metadata = r.read(input2, this.isStrict(options2));
            return metadata;
        }
        catch (XmlPullParserException e) {
            throw new MetadataParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close(input2);
        }
    }

    @Override
    public Metadata read(InputStream input2, Map<String, ?> options2) throws IOException {
        Validate.notNull(input2, "input cannot be null", new Object[0]);
        try {
            MetadataXpp3Reader r = new MetadataXpp3Reader();
            Metadata metadata = r.read(input2, this.isStrict(options2));
            return metadata;
        }
        catch (XmlPullParserException e) {
            throw new MetadataParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close(input2);
        }
    }

    private boolean isStrict(Map<String, ?> options2) {
        Object value2 = options2 != null ? (Object)options2.get("org.apache.maven.artifact.repository.metadata.io.isStrict") : null;
        return value2 == null || Boolean.parseBoolean(value2.toString());
    }
}

