/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.layout;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ArtifactRepositoryLayout.class, hint="flat")
public class FlatRepositoryLayout
implements ArtifactRepositoryLayout {
    private static final char ARTIFACT_SEPARATOR = '-';
    private static final char GROUP_SEPARATOR = '.';

    @Override
    public String getId() {
        return "flat";
    }

    @Override
    public String pathOf(Artifact artifact) {
        ArtifactHandler artifactHandler = artifact.getArtifactHandler();
        StringBuilder path2 = new StringBuilder(128);
        path2.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
        if (artifact.hasClassifier()) {
            path2.append('-').append(artifact.getClassifier());
        }
        if (artifactHandler.getExtension() != null && artifactHandler.getExtension().length() > 0) {
            path2.append('.').append(artifactHandler.getExtension());
        }
        return path2.toString();
    }

    @Override
    public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
        return this.pathOfRepositoryMetadata(metadata.getLocalFilename(repository));
    }

    private String pathOfRepositoryMetadata(String filename) {
        StringBuilder path2 = new StringBuilder(128);
        path2.append(filename);
        return path2.toString();
    }

    @Override
    public String pathOfRemoteRepositoryMetadata(ArtifactMetadata metadata) {
        return this.pathOfRepositoryMetadata(metadata.getRemoteFilename());
    }

    public String toString() {
        return this.getId();
    }
}

