/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.repository.Proxy;

public class MavenArtifactRepository
implements ArtifactRepository {
    private String id;
    private String url;
    private String basedir;
    private String protocol;
    private ArtifactRepositoryLayout layout;
    private ArtifactRepositoryPolicy snapshots;
    private ArtifactRepositoryPolicy releases;
    private Authentication authentication;
    private Proxy proxy;
    private List<ArtifactRepository> mirroredRepositories = Collections.emptyList();

    public MavenArtifactRepository() {
    }

    public MavenArtifactRepository(String id, String url, ArtifactRepositoryLayout layout, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) {
        this.id = id;
        this.url = url;
        this.layout = layout;
        this.snapshots = snapshots;
        this.releases = releases;
        this.protocol = MavenArtifactRepository.protocol(url);
        this.basedir = this.basedir(url);
    }

    @Override
    public String pathOf(Artifact artifact) {
        return this.layout.pathOf(artifact);
    }

    @Override
    public String pathOfRemoteRepositoryMetadata(ArtifactMetadata artifactMetadata) {
        return this.layout.pathOfRemoteRepositoryMetadata(artifactMetadata);
    }

    @Override
    public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
        return this.layout.pathOfLocalRepositoryMetadata(metadata, repository);
    }

    @Override
    public void setLayout(ArtifactRepositoryLayout layout) {
        this.layout = layout;
    }

    @Override
    public ArtifactRepositoryLayout getLayout() {
        return this.layout;
    }

    @Override
    public void setSnapshotUpdatePolicy(ArtifactRepositoryPolicy snapshots) {
        this.snapshots = snapshots;
    }

    @Override
    public ArtifactRepositoryPolicy getSnapshots() {
        return this.snapshots;
    }

    @Override
    public void setReleaseUpdatePolicy(ArtifactRepositoryPolicy releases) {
        this.releases = releases;
    }

    @Override
    public ArtifactRepositoryPolicy getReleases() {
        return this.releases;
    }

    @Override
    public String getKey() {
        return this.getId();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("      id: ").append(this.getId()).append("\n");
        sb.append("      url: ").append(this.getUrl()).append("\n");
        sb.append("   layout: ").append(this.layout != null ? this.layout : "none").append("\n");
        if (this.proxy != null) {
            sb.append("    proxy: ").append(this.proxy.getHost()).append(":").append(this.proxy.getPort()).append("\n");
        }
        if (this.snapshots != null) {
            sb.append("snapshots: [enabled => ").append(this.snapshots.isEnabled());
            sb.append(", update => ").append(this.snapshots.getUpdatePolicy()).append("]\n");
        }
        if (this.releases != null) {
            sb.append(" releases: [enabled => ").append(this.releases.isEnabled());
            sb.append(", update => ").append(this.releases.getUpdatePolicy()).append("]\n");
        }
        return sb.toString();
    }

    @Override
    public Artifact find(Artifact artifact) {
        File artifactFile = new File(this.getBasedir(), this.pathOf(artifact));
        artifact.setFile(artifactFile);
        return artifact;
    }

    @Override
    public List<String> findVersions(Artifact artifact) {
        return Collections.emptyList();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getBasedir() {
        return this.basedir;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
        this.protocol = MavenArtifactRepository.protocol(url);
        this.basedir = this.basedir(url);
    }

    private static String protocol(String url) {
        int pos2 = url.indexOf(":");
        if (pos2 == -1) {
            return "";
        }
        return url.substring(0, pos2).trim();
    }

    private String basedir(String url) {
        String retValue = null;
        if (this.protocol.equalsIgnoreCase("file")) {
            retValue = url.substring(this.protocol.length() + 1);
            if ((retValue = MavenArtifactRepository.decode(retValue)).startsWith("//")) {
                if ((retValue = retValue.substring(2)).length() >= 2 && (retValue.charAt(1) == '|' || retValue.charAt(1) == ':')) {
                    retValue = retValue.charAt(0) + ":" + retValue.substring(2);
                } else {
                    int index = retValue.indexOf("/");
                    if (index >= 0) {
                        retValue = retValue.substring(index + 1);
                    }
                    if (retValue.length() >= 2 && (retValue.charAt(1) == '|' || retValue.charAt(1) == ':')) {
                        retValue = retValue.charAt(0) + ":" + retValue.substring(2);
                    } else if (index >= 0) {
                        retValue = "/" + retValue;
                    }
                }
            }
            if (retValue.length() >= 2 && retValue.charAt(1) == '|') {
                retValue = retValue.charAt(0) + ":" + retValue.substring(2);
            }
            retValue = new File(retValue).getPath();
        }
        if (retValue == null) {
            retValue = "/";
        }
        return retValue.trim();
    }

    private static String decode(String url) {
        String decoded = url;
        if (url != null) {
            int pos2 = -1;
            while ((pos2 = decoded.indexOf(37, pos2 + 1)) >= 0) {
                if (pos2 + 2 >= decoded.length()) continue;
                String hexStr = decoded.substring(pos2 + 1, pos2 + 3);
                char ch = (char)Integer.parseInt(hexStr, 16);
                decoded = decoded.substring(0, pos2) + ch + decoded.substring(pos2 + 3);
            }
        }
        return decoded;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.getId() == null ? 0 : this.getId().hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactRepository other = (ArtifactRepository)obj;
        return MavenArtifactRepository.eq(this.getId(), other.getId());
    }

    protected static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    @Override
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @Override
    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    @Override
    public Proxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(Proxy proxy2) {
        this.proxy = proxy2;
    }

    @Override
    public boolean isBlacklisted() {
        return false;
    }

    @Override
    public void setBlacklisted(boolean blackListed) {
    }

    @Override
    public boolean isUniqueVersion() {
        return true;
    }

    @Override
    public boolean isProjectAware() {
        return false;
    }

    @Override
    public List<ArtifactRepository> getMirroredRepositories() {
        return this.mirroredRepositories;
    }

    @Override
    public void setMirroredRepositories(List<ArtifactRepository> mirroredRepositories) {
        this.mirroredRepositories = mirroredRepositories != null ? mirroredRepositories : Collections.emptyList();
    }
}

