/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.repository.Proxy;
import org.apache.maven.wagon.repository.Repository;

@Deprecated
public class DefaultArtifactRepository
extends Repository
implements ArtifactRepository {
    private ArtifactRepositoryLayout layout;
    private ArtifactRepositoryPolicy snapshots;
    private ArtifactRepositoryPolicy releases;
    private boolean blacklisted;
    private Authentication authentication;
    private Proxy proxy;
    private List<ArtifactRepository> mirroredRepositories = Collections.emptyList();

    public DefaultArtifactRepository(String id, String url, ArtifactRepositoryLayout layout) {
        this(id, url, layout, null, null);
    }

    public DefaultArtifactRepository(String id, String url, ArtifactRepositoryLayout layout, boolean uniqueVersion) {
        super(id, url);
        this.layout = layout;
    }

    public DefaultArtifactRepository(String id, String url, ArtifactRepositoryLayout layout, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) {
        super(id, url);
        this.layout = layout;
        if (snapshots == null) {
            snapshots = new ArtifactRepositoryPolicy(true, "always", "ignore");
        }
        this.snapshots = snapshots;
        if (releases == null) {
            releases = new ArtifactRepositoryPolicy(true, "always", "ignore");
        }
        this.releases = releases;
    }

    @Override
    public String pathOf(Artifact artifact) {
        return this.layout.pathOf(artifact);
    }

    @Override
    public String pathOfRemoteRepositoryMetadata(ArtifactMetadata artifactMetadata) {
        return this.layout.pathOfRemoteRepositoryMetadata(artifactMetadata);
    }

    @Override
    public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
        return this.layout.pathOfLocalRepositoryMetadata(metadata, repository);
    }

    @Override
    public void setLayout(ArtifactRepositoryLayout layout) {
        this.layout = layout;
    }

    @Override
    public ArtifactRepositoryLayout getLayout() {
        return this.layout;
    }

    @Override
    public void setSnapshotUpdatePolicy(ArtifactRepositoryPolicy snapshots) {
        this.snapshots = snapshots;
    }

    @Override
    public ArtifactRepositoryPolicy getSnapshots() {
        return this.snapshots;
    }

    @Override
    public void setReleaseUpdatePolicy(ArtifactRepositoryPolicy releases) {
        this.releases = releases;
    }

    @Override
    public ArtifactRepositoryPolicy getReleases() {
        return this.releases;
    }

    @Override
    public String getKey() {
        return this.getId();
    }

    @Override
    public boolean isBlacklisted() {
        return this.blacklisted;
    }

    @Override
    public void setBlacklisted(boolean blacklisted) {
        this.blacklisted = blacklisted;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("       id: ").append(this.getId()).append("\n");
        sb.append("      url: ").append(this.getUrl()).append("\n");
        sb.append("   layout: ").append(this.layout != null ? this.layout : "none").append("\n");
        if (this.snapshots != null) {
            sb.append("snapshots: [enabled => ").append(this.snapshots.isEnabled());
            sb.append(", update => ").append(this.snapshots.getUpdatePolicy()).append("]\n");
        }
        if (this.releases != null) {
            sb.append(" releases: [enabled => ").append(this.releases.isEnabled());
            sb.append(", update => ").append(this.releases.getUpdatePolicy()).append("]\n");
        }
        return sb.toString();
    }

    @Override
    public Artifact find(Artifact artifact) {
        File artifactFile = new File(this.getBasedir(), this.pathOf(artifact));
        artifact.setFile(artifactFile);
        if (artifactFile.exists()) {
            artifact.setResolved(true);
        }
        return artifact;
    }

    @Override
    public List<String> findVersions(Artifact artifact) {
        return Collections.emptyList();
    }

    @Override
    public boolean isProjectAware() {
        return false;
    }

    @Override
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @Override
    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    @Override
    public Proxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(Proxy proxy2) {
        this.proxy = proxy2;
    }

    @Override
    public boolean isUniqueVersion() {
        return true;
    }

    @Override
    public List<ArtifactRepository> getMirroredRepositories() {
        return this.mirroredRepositories;
    }

    @Override
    public void setMirroredRepositories(List<ArtifactRepository> mirroredRepositories) {
        this.mirroredRepositories = mirroredRepositories != null ? mirroredRepositories : Collections.emptyList();
    }
}

