/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.manager;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.repository.MirrorSelector;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=WagonManager.class)
public class DefaultWagonManager
extends org.apache.maven.repository.legacy.DefaultWagonManager
implements WagonManager {
    @Requirement
    private Logger log;
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private SettingsDecrypter settingsDecrypter;
    @Requirement
    private MirrorSelector mirrorSelector;
    @Requirement
    private ArtifactRepositoryFactory artifactRepositoryFactory;

    @Override
    public AuthenticationInfo getAuthenticationInfo(String id) {
        List<Server> servers;
        MavenExecutionRequest request;
        MavenSession session = this.legacySupport.getSession();
        if (session != null && id != null && (request = session.getRequest()) != null && (servers = request.getServers()) != null) {
            for (Server server : servers) {
                if (!id.equalsIgnoreCase(server.getId())) continue;
                SettingsDecryptionResult result2 = this.settingsDecrypter.decrypt(new DefaultSettingsDecryptionRequest(server));
                server = result2.getServer();
                AuthenticationInfo authInfo = new AuthenticationInfo();
                authInfo.setUserName(server.getUsername());
                authInfo.setPassword(server.getPassword());
                authInfo.setPrivateKey(server.getPrivateKey());
                authInfo.setPassphrase(server.getPassphrase());
                return authInfo;
            }
        }
        return new AuthenticationInfo();
    }

    @Override
    public ProxyInfo getProxy(String protocol) {
        List<Proxy> proxies;
        MavenExecutionRequest request;
        MavenSession session = this.legacySupport.getSession();
        if (session != null && protocol != null && (request = session.getRequest()) != null && (proxies = request.getProxies()) != null) {
            for (Proxy proxy2 : proxies) {
                if (!proxy2.isActive() || !protocol.equalsIgnoreCase(proxy2.getProtocol())) continue;
                SettingsDecryptionResult result2 = this.settingsDecrypter.decrypt(new DefaultSettingsDecryptionRequest(proxy2));
                proxy2 = result2.getProxy();
                ProxyInfo proxyInfo = new ProxyInfo();
                proxyInfo.setHost(proxy2.getHost());
                proxyInfo.setType(proxy2.getProtocol());
                proxyInfo.setPort(proxy2.getPort());
                proxyInfo.setNonProxyHosts(proxy2.getNonProxyHosts());
                proxyInfo.setUserName(proxy2.getUsername());
                proxyInfo.setPassword(proxy2.getPassword());
                return proxyInfo;
            }
        }
        return null;
    }

    @Override
    public void getArtifact(Artifact artifact, ArtifactRepository repository) throws TransferFailedException, ResourceDoesNotExistException {
        this.getArtifact(artifact, repository, null, false);
    }

    @Override
    public void getArtifact(Artifact artifact, List<ArtifactRepository> remoteRepositories) throws TransferFailedException, ResourceDoesNotExistException {
        this.getArtifact(artifact, remoteRepositories, null, false);
    }

    @Override
    @Deprecated
    public ArtifactRepository getMirrorRepository(ArtifactRepository repository) {
        Mirror mirror = this.mirrorSelector.getMirror(repository, this.legacySupport.getSession().getSettings().getMirrors());
        if (mirror != null) {
            String id = mirror.getId();
            if (id == null) {
                id = repository.getId();
            }
            this.log.debug("Using mirror: " + mirror.getUrl() + " (id: " + id + ")");
            repository = this.artifactRepositoryFactory.createArtifactRepository(id, mirror.getUrl(), repository.getLayout(), repository.getSnapshots(), repository.getReleases());
        }
        return repository;
    }
}

