/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.ManifestSection;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.PomPropertiesUtil;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedPropertiesValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

public class MavenArchiver {
    public static final String SIMPLE_LAYOUT = "${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}";
    public static final String REPOSITORY_LAYOUT = "${artifact.groupIdPath}/${artifact.artifactId}/${artifact.baseVersion}/${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}";
    public static final String SIMPLE_LAYOUT_NONUNIQUE = "${artifact.artifactId}-${artifact.baseVersion}${dashClassifier?}.${artifact.extension}";
    public static final String REPOSITORY_LAYOUT_NONUNIQUE = "${artifact.groupIdPath}/${artifact.artifactId}/${artifact.baseVersion}/${artifact.artifactId}-${artifact.baseVersion}${dashClassifier?}.${artifact.extension}";
    private static final List<String> ARTIFACT_EXPRESSION_PREFIXES;
    private JarArchiver archiver;
    private File archiveFile;

    public Manifest getManifest(MavenSession session, MavenProject project, MavenArchiveConfiguration config) throws ManifestException, DependencyResolutionRequiredException {
        boolean hasManifestEntries = !config.isManifestEntriesEmpty();
        Map<String, String> entries2 = hasManifestEntries ? config.getManifestEntries() : Collections.emptyMap();
        Manifest manifest2 = this.getManifest(session, project, config.getManifest(), entries2);
        if (hasManifestEntries) {
            for (Map.Entry entry2 : entries2.entrySet()) {
                String key = (String)entry2.getKey();
                String value2 = (String)entry2.getValue();
                Manifest.ExistingAttribute attr = manifest2.getMainSection().getAttribute(key);
                if (key.equals("ClassPath") && attr != null) {
                    ((Manifest.Attribute)attr).setValue(value2 + " " + ((Manifest.Attribute)attr).getValue());
                    continue;
                }
                this.addManifestAttribute(manifest2, key, value2);
            }
        }
        if (!config.isManifestSectionsEmpty()) {
            for (ManifestSection manifestSection : config.getManifestSections()) {
                Manifest.Section theSection = new Manifest.Section();
                theSection.setName(manifestSection.getName());
                if (!manifestSection.isManifestEntriesEmpty()) {
                    Map<String, String> sectionEntries = manifestSection.getManifestEntries();
                    for (Map.Entry<String, String> entry3 : sectionEntries.entrySet()) {
                        String key = entry3.getKey();
                        String value3 = entry3.getValue();
                        Manifest.Attribute attr = new Manifest.Attribute(key, value3);
                        theSection.addConfiguredAttribute(attr);
                    }
                }
                manifest2.addConfiguredSection(theSection);
            }
        }
        return manifest2;
    }

    public Manifest getManifest(MavenProject project, ManifestConfiguration config) throws ManifestException, DependencyResolutionRequiredException {
        return this.getManifest(null, project, config, Collections.emptyMap());
    }

    public Manifest getManifest(MavenSession mavenSession, MavenProject project, ManifestConfiguration config) throws ManifestException, DependencyResolutionRequiredException {
        return this.getManifest(mavenSession, project, config, Collections.emptyMap());
    }

    private void addManifestAttribute(Manifest manifest2, Map<String, String> map2, String key, String value2) throws ManifestException {
        if (map2.containsKey(key)) {
            return;
        }
        this.addManifestAttribute(manifest2, key, value2);
    }

    private void addManifestAttribute(Manifest manifest2, String key, String value2) throws ManifestException {
        if (!StringUtils.isEmpty(value2)) {
            Manifest.Attribute attr = new Manifest.Attribute(key, value2);
            manifest2.addConfiguredAttribute(attr);
        } else {
            Manifest.Attribute attr = new Manifest.Attribute(key, "");
            manifest2.addConfiguredAttribute(attr);
        }
    }

    protected Manifest getManifest(MavenSession session, MavenProject project, ManifestConfiguration config, Map<String, String> entries2) throws ManifestException, DependencyResolutionRequiredException {
        String mainClass2;
        Manifest m = new Manifest();
        this.addCreatedByEntry(session, m, entries2);
        this.addCustomEntries(m, entries2, config);
        if (config.isAddClasspath()) {
            StringBuilder classpath = new StringBuilder();
            List<String> artifacts = project.getRuntimeClasspathElements();
            String classpathPrefix = config.getClasspathPrefix();
            String layoutType = config.getClasspathLayoutType();
            String layout = config.getCustomClasspathLayout();
            StringSearchInterpolator interpolator = new StringSearchInterpolator();
            for (String artifactFile : artifacts) {
                File f2 = new File(artifactFile);
                if (!f2.getAbsoluteFile().isFile()) continue;
                Artifact artifact = this.findArtifactWithFile(project.getArtifacts(), f2);
                if (classpath.length() > 0) {
                    classpath.append(" ");
                }
                classpath.append(classpathPrefix);
                if (artifact == null || layoutType == null) {
                    classpath.append(f2.getName());
                    continue;
                }
                ArrayList<ValueSource> valueSources = new ArrayList<ValueSource>();
                this.handleExtraExpression(artifact, valueSources);
                for (ValueSource vs : valueSources) {
                    interpolator.addValueSource(vs);
                }
                PrefixAwareRecursionInterceptor recursionInterceptor = new PrefixAwareRecursionInterceptor(ARTIFACT_EXPRESSION_PREFIXES);
                try {
                    if ("simple".equals(layoutType)) {
                        if (config.isUseUniqueVersions()) {
                            classpath.append(interpolator.interpolate(SIMPLE_LAYOUT, recursionInterceptor));
                            continue;
                        }
                        classpath.append(interpolator.interpolate(SIMPLE_LAYOUT_NONUNIQUE, recursionInterceptor));
                        continue;
                    }
                    if ("repository".equals(layoutType)) {
                        if (config.isUseUniqueVersions()) {
                            classpath.append(interpolator.interpolate(REPOSITORY_LAYOUT, recursionInterceptor));
                            continue;
                        }
                        classpath.append(interpolator.interpolate(REPOSITORY_LAYOUT_NONUNIQUE, recursionInterceptor));
                        continue;
                    }
                    if ("custom".equals(layoutType)) {
                        if (layout == null) {
                            throw new ManifestException("custom layout type was declared, but custom layout expression was not specified. Check your <archive><manifest><customLayout/> element.");
                        }
                        classpath.append(interpolator.interpolate(layout, recursionInterceptor));
                        continue;
                    }
                    throw new ManifestException("Unknown classpath layout type: '" + layoutType + "'. Check your <archive><manifest><layoutType/> element.");
                }
                catch (InterpolationException e) {
                    ManifestException error2 = new ManifestException("Error interpolating artifact path for classpath entry: " + e.getMessage());
                    error2.initCause(e);
                    throw error2;
                }
                finally {
                    for (ValueSource vs : valueSources) {
                        interpolator.removeValuesSource(vs);
                    }
                }
            }
            if (classpath.length() > 0) {
                this.addManifestAttribute(m, "Class-Path", classpath.toString());
            }
        }
        if (config.isAddDefaultSpecificationEntries()) {
            this.handleSpecificationEntries(project, entries2, m);
        }
        if (config.isAddDefaultImplementationEntries()) {
            this.handleImplementationEntries(project, entries2, m);
        }
        if ((mainClass2 = config.getMainClass()) != null && !"".equals(mainClass2)) {
            this.addManifestAttribute(m, entries2, "Main-Class", mainClass2);
        }
        if (config.isAddExtensions()) {
            this.handleExtensions(project, entries2, m);
        }
        return m;
    }

    private void handleExtraExpression(Artifact artifact, List<ValueSource> valueSources) {
        valueSources.add(new PrefixedObjectValueSource(ARTIFACT_EXPRESSION_PREFIXES, artifact, true));
        valueSources.add(new PrefixedObjectValueSource(ARTIFACT_EXPRESSION_PREFIXES, artifact.getArtifactHandler(), true));
        Properties extraExpressions = new Properties();
        if (!artifact.isSnapshot()) {
            extraExpressions.setProperty("baseVersion", artifact.getVersion());
        }
        extraExpressions.setProperty("groupIdPath", artifact.getGroupId().replace('.', '/'));
        if (StringUtils.isNotEmpty(artifact.getClassifier())) {
            extraExpressions.setProperty("dashClassifier", "-" + artifact.getClassifier());
            extraExpressions.setProperty("dashClassifier?", "-" + artifact.getClassifier());
        } else {
            extraExpressions.setProperty("dashClassifier", "");
            extraExpressions.setProperty("dashClassifier?", "");
        }
        valueSources.add(new PrefixedPropertiesValueSource(ARTIFACT_EXPRESSION_PREFIXES, extraExpressions, true));
    }

    private void handleExtensions(MavenProject project, Map<String, String> entries2, Manifest m) throws ManifestException {
        StringBuilder extensionsList = new StringBuilder();
        Set<Artifact> artifacts = project.getArtifacts();
        for (Artifact artifact : artifacts) {
            if ("test".equals(artifact.getScope()) || !"jar".equals(artifact.getType())) continue;
            if (extensionsList.length() > 0) {
                extensionsList.append(" ");
            }
            extensionsList.append(artifact.getArtifactId());
        }
        if (extensionsList.length() > 0) {
            this.addManifestAttribute(m, entries2, "Extension-List", extensionsList.toString());
        }
        for (Artifact artifact1 : artifacts) {
            Artifact artifact = artifact1;
            if (!"jar".equals(artifact.getType())) continue;
            String artifactId = artifact.getArtifactId().replace('.', '_');
            String ename = artifactId + "-Extension-Name";
            this.addManifestAttribute(m, entries2, ename, artifact.getArtifactId());
            String iname = artifactId + "-Implementation-Version";
            this.addManifestAttribute(m, entries2, iname, artifact.getVersion());
            if (artifact.getRepository() == null) continue;
            iname = artifactId + "-Implementation-URL";
            String url = artifact.getRepository().getUrl() + "/" + artifact.toString();
            this.addManifestAttribute(m, entries2, iname, url);
        }
    }

    private void handleImplementationEntries(MavenProject project, Map<String, String> entries2, Manifest m) throws ManifestException {
        this.addManifestAttribute(m, entries2, "Implementation-Title", project.getName());
        this.addManifestAttribute(m, entries2, "Implementation-Version", project.getVersion());
        this.addManifestAttribute(m, entries2, "Implementation-Vendor-Id", project.getGroupId());
        if (project.getOrganization() != null) {
            this.addManifestAttribute(m, entries2, "Implementation-Vendor", project.getOrganization().getName());
        }
        if (project.getUrl() != null) {
            this.addManifestAttribute(m, entries2, "Implementation-URL", project.getUrl());
        }
    }

    private void handleSpecificationEntries(MavenProject project, Map<String, String> entries2, Manifest m) throws ManifestException {
        this.addManifestAttribute(m, entries2, "Specification-Title", project.getName());
        try {
            ArtifactVersion version = project.getArtifact().getSelectedVersion();
            String specVersion = String.format("%s.%s", version.getMajorVersion(), version.getMinorVersion());
            this.addManifestAttribute(m, entries2, "Specification-Version", specVersion);
        }
        catch (OverConstrainedVersionException e) {
            throw new ManifestException("Failed to get selected artifact version to calculate the specification version: " + e.getMessage());
        }
        if (project.getOrganization() != null) {
            this.addManifestAttribute(m, entries2, "Specification-Vendor", project.getOrganization().getName());
        }
    }

    private void addCustomEntries(Manifest m, Map<String, String> entries2, ManifestConfiguration config) throws ManifestException {
        this.addManifestAttribute(m, entries2, "Built-By", System.getProperty("user.name"));
        this.addManifestAttribute(m, entries2, "Build-Jdk", System.getProperty("java.version"));
        if (config.getPackageName() != null) {
            this.addManifestAttribute(m, entries2, "Package", config.getPackageName());
        }
    }

    public JarArchiver getArchiver() {
        return this.archiver;
    }

    public void setArchiver(JarArchiver archiver) {
        this.archiver = archiver;
    }

    public void setOutputFile(File outputFile) {
        this.archiveFile = outputFile;
    }

    public void createArchive(MavenSession session, MavenProject project, MavenArchiveConfiguration archiveConfiguration) throws ManifestException, IOException, DependencyResolutionRequiredException {
        File manifestFile;
        MavenProject workingProject = null;
        workingProject = project.clone();
        boolean forced = archiveConfiguration.isForced();
        if (archiveConfiguration.isAddMavenDescriptor()) {
            if (workingProject.getArtifact().isSnapshot()) {
                workingProject.setVersion(workingProject.getArtifact().getVersion());
            }
            String groupId = workingProject.getGroupId();
            String artifactId = workingProject.getArtifactId();
            this.archiver.addFile(project.getFile(), "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
            File customPomPropertiesFile = archiveConfiguration.getPomPropertiesFile();
            File dir = new File(workingProject.getBuild().getDirectory(), "maven-archiver");
            File pomPropertiesFile = new File(dir, "pom.properties");
            new PomPropertiesUtil().createPomProperties(session, workingProject, this.archiver, customPomPropertiesFile, pomPropertiesFile, forced);
        }
        if ((manifestFile = archiveConfiguration.getManifestFile()) != null) {
            this.archiver.setManifest(manifestFile);
        }
        Manifest manifest2 = this.getManifest(session, workingProject, archiveConfiguration);
        this.archiver.addConfiguredManifest(manifest2);
        this.archiver.setCompress(archiveConfiguration.isCompress());
        this.archiver.setRecompressAddedZips(archiveConfiguration.isRecompressAddedZips());
        this.archiver.setIndex(archiveConfiguration.isIndex());
        this.archiver.setDestFile(this.archiveFile);
        if (archiveConfiguration.getManifest().isAddClasspath()) {
            List<String> artifacts = project.getRuntimeClasspathElements();
            for (String artifact : artifacts) {
                File f2 = new File(artifact);
                this.archiver.addConfiguredIndexJars(f2);
            }
        }
        this.archiver.setForced(forced);
        if (archiveConfiguration.isForced() || this.archiver.isSupportingForced()) {
            // empty if block
        }
        this.archiver.createArchive();
    }

    private void addCreatedByEntry(MavenSession session, Manifest m, Map<String, String> entries2) throws ManifestException {
        String mavenVersion;
        String createdBy = "Apache Maven";
        if (session != null && (mavenVersion = session.getSystemProperties().getProperty("maven.version")) != null) {
            createdBy = createdBy + " " + mavenVersion;
        }
        this.addManifestAttribute(m, entries2, "Created-By", createdBy);
    }

    private Artifact findArtifactWithFile(Set<Artifact> artifacts, File file) {
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null || !artifact.getFile().equals(file)) continue;
            return artifact;
        }
        return null;
    }

    static {
        ArrayList<String> artifactExpressionPrefixes = new ArrayList<String>();
        artifactExpressionPrefixes.add("artifact.");
        ARTIFACT_EXPRESSION_PREFIXES = artifactExpressionPrefixes;
    }
}

