/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.repository.Proxy;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

public class RepositoryUtils {
    private static String nullify(String string2) {
        return string2 == null || string2.length() <= 0 ? null : string2;
    }

    private static Artifact toArtifact(org.eclipse.aether.graph.Dependency dependency) {
        if (dependency == null) {
            return null;
        }
        Artifact result2 = RepositoryUtils.toArtifact(dependency.getArtifact());
        result2.setScope(dependency.getScope());
        result2.setOptional(dependency.isOptional());
        return result2;
    }

    public static Artifact toArtifact(org.eclipse.aether.artifact.Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        ArtifactHandler handler = RepositoryUtils.newHandler(artifact);
        DefaultArtifact result2 = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), null, artifact.getProperty("type", artifact.getExtension()), RepositoryUtils.nullify(artifact.getClassifier()), handler);
        result2.setFile(artifact.getFile());
        result2.setResolved(artifact.getFile() != null);
        ArrayList<String> trail = new ArrayList<String>(1);
        trail.add(result2.getId());
        result2.setDependencyTrail(trail);
        return result2;
    }

    public static void toArtifacts(Collection<Artifact> artifacts, Collection<? extends DependencyNode> nodes2, List<String> trail, DependencyFilter filter2) {
        for (DependencyNode dependencyNode : nodes2) {
            Artifact artifact = RepositoryUtils.toArtifact(dependencyNode.getDependency());
            ArrayList<String> nodeTrail = new ArrayList<String>(trail.size() + 1);
            nodeTrail.addAll(trail);
            nodeTrail.add(artifact.getId());
            if (filter2 == null || filter2.accept(dependencyNode, Collections.emptyList())) {
                artifact.setDependencyTrail(nodeTrail);
                artifacts.add(artifact);
            }
            RepositoryUtils.toArtifacts(artifacts, dependencyNode.getChildren(), nodeTrail, filter2);
        }
    }

    public static org.eclipse.aether.artifact.Artifact toArtifact(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        String version = artifact.getVersion();
        if (version == null && artifact.getVersionRange() != null) {
            version = artifact.getVersionRange().toString();
        }
        Map<String, String> props = null;
        if ("system".equals(artifact.getScope())) {
            String localPath = artifact.getFile() != null ? artifact.getFile().getPath() : "";
            props = Collections.singletonMap("localPath", localPath);
        }
        org.eclipse.aether.artifact.Artifact result2 = new org.eclipse.aether.artifact.DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getArtifactHandler().getExtension(), version, props, RepositoryUtils.newArtifactType(artifact.getType(), artifact.getArtifactHandler()));
        result2 = result2.setFile(artifact.getFile());
        return result2;
    }

    public static org.eclipse.aether.graph.Dependency toDependency(Artifact artifact, Collection<Exclusion> exclusions) {
        if (artifact == null) {
            return null;
        }
        org.eclipse.aether.artifact.Artifact result2 = RepositoryUtils.toArtifact(artifact);
        ArrayList<org.eclipse.aether.graph.Exclusion> excl = null;
        if (exclusions != null) {
            excl = new ArrayList<org.eclipse.aether.graph.Exclusion>(exclusions.size());
            for (Exclusion exclusion : exclusions) {
                excl.add(RepositoryUtils.toExclusion(exclusion));
            }
        }
        return new org.eclipse.aether.graph.Dependency(result2, artifact.getScope(), artifact.isOptional(), excl);
    }

    public static List<RemoteRepository> toRepos(List<ArtifactRepository> repos) {
        if (repos == null) {
            return null;
        }
        ArrayList<RemoteRepository> results = new ArrayList<RemoteRepository>(repos.size());
        for (ArtifactRepository repo : repos) {
            results.add(RepositoryUtils.toRepo(repo));
        }
        return results;
    }

    public static RemoteRepository toRepo(ArtifactRepository repo) {
        RemoteRepository result2 = null;
        if (repo != null) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(repo.getId(), RepositoryUtils.getLayout(repo), repo.getUrl());
            builder.setSnapshotPolicy(RepositoryUtils.toPolicy(repo.getSnapshots()));
            builder.setReleasePolicy(RepositoryUtils.toPolicy(repo.getReleases()));
            builder.setAuthentication(RepositoryUtils.toAuthentication(repo.getAuthentication()));
            builder.setProxy(RepositoryUtils.toProxy(repo.getProxy()));
            builder.setMirroredRepositories(RepositoryUtils.toRepos(repo.getMirroredRepositories()));
            result2 = builder.build();
        }
        return result2;
    }

    public static String getLayout(ArtifactRepository repo) {
        try {
            return repo.getLayout().getId();
        }
        catch (LinkageError e) {
            String layout;
            String className = repo.getLayout().getClass().getSimpleName();
            if (className.endsWith("RepositoryLayout") && (layout = className.substring(0, className.length() - "RepositoryLayout".length())).length() > 0) {
                layout = Character.toLowerCase(layout.charAt(0)) + layout.substring(1);
                return layout;
            }
            return "";
        }
    }

    private static RepositoryPolicy toPolicy(ArtifactRepositoryPolicy policy) {
        RepositoryPolicy result2 = null;
        if (policy != null) {
            result2 = new RepositoryPolicy(policy.isEnabled(), policy.getUpdatePolicy(), policy.getChecksumPolicy());
        }
        return result2;
    }

    private static org.eclipse.aether.repository.Authentication toAuthentication(Authentication auth) {
        org.eclipse.aether.repository.Authentication result2 = null;
        if (auth != null) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(auth.getUsername()).addPassword(auth.getPassword());
            authBuilder.addPrivateKey(auth.getPrivateKey(), auth.getPassphrase());
            result2 = authBuilder.build();
        }
        return result2;
    }

    private static org.eclipse.aether.repository.Proxy toProxy(Proxy proxy2) {
        org.eclipse.aether.repository.Proxy result2 = null;
        if (proxy2 != null) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(proxy2.getUserName()).addPassword(proxy2.getPassword());
            result2 = new org.eclipse.aether.repository.Proxy(proxy2.getProtocol(), proxy2.getHost(), proxy2.getPort(), authBuilder.build());
        }
        return result2;
    }

    public static ArtifactHandler newHandler(org.eclipse.aether.artifact.Artifact artifact) {
        String type = artifact.getProperty("type", artifact.getExtension());
        DefaultArtifactHandler handler = new DefaultArtifactHandler(type);
        handler.setExtension(artifact.getExtension());
        handler.setLanguage(artifact.getProperty("language", null));
        String addedToClasspath = artifact.getProperty("constitutesBuildPath", "");
        handler.setAddedToClasspath(Boolean.parseBoolean(addedToClasspath));
        String includesDependencies = artifact.getProperty("includesDependencies", "");
        handler.setIncludesDependencies(Boolean.parseBoolean(includesDependencies));
        return handler;
    }

    public static ArtifactType newArtifactType(String id, ArtifactHandler handler) {
        return new DefaultArtifactType(id, handler.getExtension(), handler.getClassifier(), handler.getLanguage(), handler.isAddedToClasspath(), handler.isIncludesDependencies());
    }

    public static org.eclipse.aether.graph.Dependency toDependency(Dependency dependency, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        org.eclipse.aether.artifact.DefaultArtifact artifact = new org.eclipse.aether.artifact.DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<org.eclipse.aether.graph.Exclusion> exclusions = new ArrayList<org.eclipse.aether.graph.Exclusion>(dependency.getExclusions().size());
        for (Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(RepositoryUtils.toExclusion(exclusion));
        }
        org.eclipse.aether.graph.Dependency result2 = new org.eclipse.aether.graph.Dependency((org.eclipse.aether.artifact.Artifact)artifact, dependency.getScope(), dependency.isOptional(), exclusions);
        return result2;
    }

    private static org.eclipse.aether.graph.Exclusion toExclusion(Exclusion exclusion) {
        return new org.eclipse.aether.graph.Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }

    public static ArtifactTypeRegistry newArtifactTypeRegistry(ArtifactHandlerManager handlerManager) {
        return new MavenArtifactTypeRegistry(handlerManager);
    }

    public static Collection<org.eclipse.aether.artifact.Artifact> toArtifacts(Collection<Artifact> artifactsToConvert) {
        ArrayList<org.eclipse.aether.artifact.Artifact> artifacts = new ArrayList<org.eclipse.aether.artifact.Artifact>();
        for (Artifact a : artifactsToConvert) {
            artifacts.add(RepositoryUtils.toArtifact(a));
        }
        return artifacts;
    }

    static class MavenArtifactTypeRegistry
    implements ArtifactTypeRegistry {
        private final ArtifactHandlerManager handlerManager;

        public MavenArtifactTypeRegistry(ArtifactHandlerManager handlerManager) {
            this.handlerManager = handlerManager;
        }

        @Override
        public ArtifactType get(String stereotypeId) {
            ArtifactHandler handler = this.handlerManager.getArtifactHandler(stereotypeId);
            return RepositoryUtils.newArtifactType(stereotypeId, handler);
        }
    }
}

