/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultExceptionContext
implements ExceptionContext,
Serializable {
    private static final long serialVersionUID = 20110706L;
    private final List<Pair<String, Object>> contextValues = new ArrayList<Pair<String, Object>>();

    @Override
    public DefaultExceptionContext addContextValue(String label, Object value2) {
        this.contextValues.add(new ImmutablePair<String, Object>(label, value2));
        return this;
    }

    @Override
    public DefaultExceptionContext setContextValue(String label, Object value2) {
        Iterator<Pair<String, Object>> iter = this.contextValues.iterator();
        while (iter.hasNext()) {
            Pair<String, Object> p = iter.next();
            if (!StringUtils.equals(label, p.getKey())) continue;
            iter.remove();
        }
        this.addContextValue(label, value2);
        return this;
    }

    @Override
    public List<Object> getContextValues(String label) {
        ArrayList<Object> values2 = new ArrayList<Object>();
        for (Pair<String, Object> pair2 : this.contextValues) {
            if (!StringUtils.equals(label, pair2.getKey())) continue;
            values2.add(pair2.getValue());
        }
        return values2;
    }

    @Override
    public Object getFirstContextValue(String label) {
        for (Pair<String, Object> pair2 : this.contextValues) {
            if (!StringUtils.equals(label, pair2.getKey())) continue;
            return pair2.getValue();
        }
        return null;
    }

    @Override
    public Set<String> getContextLabels() {
        HashSet<String> labels = new HashSet<String>();
        for (Pair<String, Object> pair2 : this.contextValues) {
            labels.add(pair2.getKey());
        }
        return labels;
    }

    @Override
    public List<Pair<String, Object>> getContextEntries() {
        return this.contextValues;
    }

    @Override
    public String getFormattedExceptionMessage(String baseMessage) {
        StringBuilder buffer = new StringBuilder(256);
        if (baseMessage != null) {
            buffer.append(baseMessage);
        }
        if (this.contextValues.size() > 0) {
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            buffer.append("Exception Context:\n");
            int i = 0;
            for (Pair<String, Object> pair2 : this.contextValues) {
                buffer.append("\t[");
                buffer.append(++i);
                buffer.append(':');
                buffer.append(pair2.getKey());
                buffer.append("=");
                Object value2 = pair2.getValue();
                if (value2 == null) {
                    buffer.append("null");
                } else {
                    String valueStr;
                    try {
                        valueStr = value2.toString();
                    }
                    catch (Exception e) {
                        valueStr = "Exception thrown on toString(): " + ExceptionUtils.getStackTrace(e);
                    }
                    buffer.append(valueStr);
                }
                buffer.append("]\n");
            }
            buffer.append("---------------------------------");
        }
        return buffer.toString();
    }
}

