/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;

public class DefaultExecuteResultHandler
implements ExecuteResultHandler {
    private static final int SLEEP_TIME_MS = 50;
    private volatile boolean hasResult = false;
    private volatile int exitValue = -559038737;
    private volatile ExecuteException exception;

    public void onProcessComplete(int exitValue2) {
        this.exitValue = exitValue2;
        this.exception = null;
        this.hasResult = true;
    }

    public void onProcessFailed(ExecuteException e) {
        this.exitValue = e.getExitValue();
        this.exception = e;
        this.hasResult = true;
    }

    public ExecuteException getException() {
        if (!this.hasResult) {
            throw new IllegalStateException("The process has not exited yet therefore no result is available ...");
        }
        return this.exception;
    }

    public int getExitValue() {
        if (!this.hasResult) {
            throw new IllegalStateException("The process has not exited yet therefore no result is available ...");
        }
        return this.exitValue;
    }

    public boolean hasResult() {
        return this.hasResult;
    }

    public void waitFor() throws InterruptedException {
        while (!this.hasResult()) {
            Thread.sleep(50L);
        }
    }

    public void waitFor(long timeout) throws InterruptedException {
        long until = System.currentTimeMillis() + timeout;
        while (!this.hasResult() && System.currentTimeMillis() < until) {
            Thread.sleep(50L);
        }
    }
}

